<?php
require_once __DIR__.'/includes/db.php';

function e($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
$pf = $conn->query("SELECT * FROM profil_warung WHERE id=1")->fetch_assoc() ?: [];

$judul     = $pf['judul']     ?? 'Tentang Kedai Kami';
$deskripsi = $pf['deskripsi'] ?? '';
$alamat    = $pf['alamat']    ?? '';
$telepon   = $pf['telepon']   ?? '';
$jam_buka  = $pf['jam_buka']  ?? '';

$foto = [];
for ($i=1; $i<=6; $i++){
  if (!empty($pf["foto$i"])) $foto[] = 'uploads/'.e($pf["foto$i"]);
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= e($judul) ?> - Kedai Salsabila</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800;900&display=swap" rel="stylesheet">
  <style>
    :root{
      --primary:#ff6b35; --primary-light:#ff8960; --accent:#06d6a0;
      --border:#e2e8f0; --muted:#64748b; --dark:#0a0e27;
      --shadow:0 10px 40px rgba(0,0,0,.1);
      --shadow-lg:0 20px 60px rgba(0,0,0,.15);
      --radius:20px; --radius-lg:26px;

      /* >>> Ubah ini untuk membesarkan thumbnail galeri <<< */
      --thumb-min: 280px;     /* contoh 320px agar lebih besar */
      --thumb-ratio: 4/3;     /* 16/10 juga oke */
    }
    *{box-sizing:border-box}
    body{
      margin:0;
      font-family:Inter,system-ui,-apple-system,'Segoe UI',Roboto,sans-serif;
      background:linear-gradient(135deg,#f5f7fa 0%,#c3cfe2 100%);
      color:var(--dark); line-height:1.6;
    }
    .container{max-width:1200px;margin:0 auto;padding:24px}

    /* Header */
    header{position:sticky;top:0;background:rgba(255,255,255,.95);backdrop-filter:blur(16px);
      border-bottom:1px solid #f1f5f9;z-index:100;transition:.3s}
    header:hover{background:rgba(255,255,255,.98);box-shadow:0 4px 20px rgba(0,0,0,.08)}
    .nav{display:flex;align-items:center;justify-content:space-between;height:76px}
    .brand{display:flex;gap:14px;align-items:center;font-weight:900;color:var(--primary);font-size:18px}
    .brand .logo{width:48px;height:48px;border-radius:14px;display:grid;place-items:center;
      background:linear-gradient(135deg,var(--primary),var(--primary-light));color:#fff;box-shadow:var(--shadow)}
    nav{display:flex;gap:12px}
    .btn{display:inline-flex;align-items:center;gap:10px;padding:14px 24px;border-radius:999px;border:2px solid var(--border);
      text-decoration:none;color:var(--dark);font-weight:700;background:#fff;transition:.3s}
    .btn:hover{transform:translateY(-2px);box-shadow:0 8px 25px rgba(0,0,0,.12)}
    .btn.primary{border-color:transparent;background:linear-gradient(135deg,var(--primary),var(--primary-light));color:#fff;box-shadow:var(--shadow)}

    /* Hero */
    .hero{margin:32px 0 48px;background:#fff;border:2px solid #f1f5f9;border-radius:var(--radius-lg);box-shadow:var(--shadow);overflow:hidden}
    .hero .topbar{height:8px;background:linear-gradient(90deg,var(--primary),var(--accent),var(--primary));
      background-size:300% 100%;animation:bar 4s infinite ease-in-out}
    @keyframes bar{0%,100%{background-position:0% 50%}50%{background-position:100% 50%}}
    .hero .wrap{display:grid;grid-template-columns:1fr 1fr;gap:32px;padding:32px;align-items:start}
    .title{font-size:42px;font-weight:900;margin:0 0 12px;
      background:linear-gradient(135deg,var(--dark) 0%,var(--primary) 70%);-webkit-background-clip:text;background-clip:text;-webkit-text-fill-color:transparent}
    .sub{color:var(--muted);margin:0 0 16px;font-size:16px;font-weight:500}
    .info-list{display:grid;gap:14px;margin:20px 0;color:#111827}
    .info-item{background:#fff;border:2px solid #f1f5f9;border-radius:16px;padding:14px 18px;display:flex;gap:12px;align-items:center}
    .desc{background:#fff;border:2px solid #f1f5f9;border-radius:var(--radius);box-shadow:var(--shadow);padding:28px;line-height:1.75;font-size:15px;position:relative}
    .desc::before{content:'';position:absolute;top:0;left:0;right:0;height:4px;background:linear-gradient(90deg,var(--primary),var(--accent));border-radius:var(--radius) var(--radius) 0 0}

    /* ===== PANEL CARD PEMBUNGKUS GALERI ===== */
    .panel{
      background:#fff; border:2px solid #f1f5f9; border-radius:var(--radius-lg);
      box-shadow:var(--shadow); overflow:hidden;
    }
    .panel-topbar{height:8px;background:linear-gradient(90deg,var(--primary),var(--accent))}
    .panel-header{display:flex;align-items:center;gap:10px;padding:18px 22px;border-bottom:1px solid #f1f5f9}
    .panel-title{margin:0;font-weight:900;font-size:22px;color:var(--dark)}
    .panel-body{padding:22px}

    /* Grid & mini-card foto di dalam panel */
    .thumb-grid{
      display:grid;gap:16px;
      grid-template-columns:repeat(auto-fill,minmax(var(--thumb-min),1fr));
    }
    .thumb-card{
      background:#fff;border:1.5px solid #e9eef5;border-radius:16px;overflow:hidden;
      box-shadow:0 6px 18px rgba(15,23,42,.06);
      transition:.25s transform,.25s box-shadow,.25s border-color;
    }
    .thumb-card:hover{transform:translateY(-4px);box-shadow:0 14px 28px rgba(15,23,42,.10);border-color:#ffc9b3}
    .thumb-media{aspect-ratio:var(--thumb-ratio);background:#f3f6fb}
    .thumb-media img{width:100%;height:100%;object-fit:cover;display:block}

    .thumb-caption{padding:10px 12px;font-weight:700;font-size:13px;color:#0f172a}
    .thumb-meta{padding:0 12px 8px;font-size:12px;color:#64748b;font-weight:600}
    .thumb-actions{display:flex;justify-content:flex-end;padding:6px 12px 14px}

    .view-btn{
      display:inline-flex;align-items:center;gap:8px;
      padding:8px 12px;border-radius:999px;border:1.5px solid #e5e7eb;
      background:#fff;color:#0f172a;text-decoration:none;font-weight:700;font-size:13px;
      box-shadow:0 6px 16px rgba(15,23,42,.06);
    }
    .view-btn:hover{background:#fff;transform:translateY(-1px);box-shadow:0 10px 22px rgba(15,23,42,.10)}

    /* Placeholder (skeleton) saat loading) */
    .thumb-media img{
      background:linear-gradient(90deg,#f0f0f0 25%,#e0e0e0 50%,#f0f0f0 75%);
      background-size:200% 100%;animation:loading 1.6s infinite;
    }
    .thumb-media img[src]:not([src=""]){animation:none;background:none}
    @keyframes loading{0%{background-position:200% 0}100%{background-position:-200% 0}}

    /* ===== Lightbox (perbesar gambar) ===== */
    .lightbox{position:fixed;inset:0;display:grid;place-items:center;z-index:9999}
    .lightbox[hidden]{display:none}
    .lb-backdrop{position:absolute;inset:0;background:rgba(15,23,42,.72);backdrop-filter:blur(3px)}
    .lb-dialog{position:relative;max-width:min(1000px,90vw);max-height:85vh;border-radius:16px;overflow:hidden;
      box-shadow:var(--shadow-lg);background:#000}
    .lb-dialog img{display:block;max-width:100%;max-height:85vh;width:auto;height:auto;object-fit:contain;background:#000}
    .lb-caption{padding:10px 14px;color:#e5e7eb;font-size:13px;background:rgba(0,0,0,.5)}
    .lb-close{position:absolute;top:8px;right:8px;border:none;background:rgba(255,255,255,.9);width:36px;height:36px;border-radius:999px;
      font-size:20px;cursor:pointer}
    .lb-close:hover{background:#fff}

    /* Footer */
    footer{margin:48px 0 32px;text-align:center;color:var(--muted);font-weight:600;font-size:14px;position:relative}
    footer::before{content:'';position:absolute;top:-20px;left:50%;transform:translateX(-50%);width:100px;height:2px;background:linear-gradient(90deg,var(--primary),var(--accent));border-radius:2px}

    /* Responsive */
    @media (max-width:1000px){.hero .wrap{grid-template-columns:1fr;gap:24px}.title{font-size:36px}}
    @media (max-width:768px){
      .container{padding:16px}
      .nav{height:70px;flex-wrap:wrap;gap:12px}
      .brand{font-size:16px}.brand .logo{width:42px;height:42px;font-size:16px}
      .btn{padding:12px 20px;font-size:14px}
      .title{font-size:32px}
      /* kalau mau thumbnail tetap besar di tablet, naikkan --thumb-min */
    }
    @media (max-width:480px){
      .nav{justify-content:center;text-align:center}.brand{margin-bottom:8px}
      .title{font-size:28px}
      /* grid otomatis 2 kolom di ponsel kalau --thumb-min sekitar 180-220px */
    }
    html{scroll-behavior:smooth}
  </style>
</head>
<body>
  <header>
    <div class="container nav">
      <div class="brand">
        <div class="logo">WS</div>
        <span>Kedai Salsabila</span>
      </div>
      <nav>
        <a class="btn" href="index.php#menu">📋 Lihat Menu</a>
        <a class="btn primary" href="index.php">🏠 Beranda</a>
      </nav>
    </div>
  </header>

  <main class="container">
    <!-- HERO -->
    <section class="hero">
      <div class="topbar"></div>
      <div class="wrap">
        <div>
          <h1 class="title"><?= e($judul) ?></h1>
          <p class="sub">Profil dan informasi lengkap tentang Kedai kami.</p>
          <div class="info-list">
            <?php if($alamat): ?>
              <div class="info-item"><span style="font-size:18px">📍</span><div><strong>Alamat:</strong><br><span><?= e($alamat) ?></span></div></div>
            <?php endif; ?>
            <?php if($telepon): ?>
              <div class="info-item"><span style="font-size:18px">📞</span><div><strong>Telepon/WhatsApp:</strong><br><span><?= e($telepon) ?></span></div></div>
            <?php endif; ?>
            <?php if($jam_buka): ?>
              <div class="info-item"><span style="font-size:18px">🕒</span><div><strong>Jam Operasional:</strong><br><span><?= e($jam_buka) ?></span></div></div>
            <?php endif; ?>
          </div>
        </div>
        <div class="desc">
          <?= $deskripsi /* pastikan sudah dibersihkan di panel admin */ ?>
        </div>
      </div>
    </section>

    <!-- ===== GALERI DIBUNGKUS CARD BESAR ===== -->
    <section>
      <div class="panel">
        <div class="panel-topbar"></div>
        <div class="panel-header">
          <span style="font-size:18px">🖼️</span>
          <h2 class="panel-title">Galeri Kedai</h2>
        </div>
        <div class="panel-body">
          <?php if(empty($foto)): ?>
            <div class="thumb-grid">
              <?php for($p=0;$p<4;$p++): ?>
                <figure class="thumb-card">
                  <div class="thumb-media">
                    <img alt="Belum ada foto" src="data:image/svg+xml,<?= urlencode('<svg xmlns=\'http://www.w3.org/2000/svg\' width=\'600\' height=\'450\'><rect width=\'100%\' height=\'100%\' fill=\'#f8fafc\'/><text x=\'50%\' y=\'52%\' dominant-baseline=\'middle\' text-anchor=\'middle\' fill=\'#94a3b8\' font-family=\'Inter,sans-serif\' font-size=\'16\' font-weight=\'700\'>📷 Belum ada foto</text></svg>') ?>">
                  </div>
                  <figcaption class="thumb-caption">Belum ada unggahan</figcaption>
                  <div class="thumb-meta">Tambahkan foto dari panel admin</div>
                </figure>
              <?php endfor; ?>
            </div>
          <?php else: ?>
            <div class="thumb-grid">
              <?php foreach($foto as $i => $src): 
                $cap = 'Foto Kedai #'.($i+1);
              ?>
                <figure class="thumb-card">
                  <div class="thumb-media">
                    <img src="<?= $src ?>" alt="<?= e($cap) ?>" loading="lazy">
                  </div>
                  <figcaption class="thumb-caption"><?= e($cap) ?></figcaption>
                  <div class="thumb-meta">Galeri Kedai Salsabila • <?= strtoupper(pathinfo($src, PATHINFO_EXTENSION)) ?></div>
                  <div class="thumb-actions">
                    <a href="#" class="view-btn" data-view-src="<?= $src ?>" data-caption="<?= e($cap) ?>">👁️ Lihat</a>
                  </div>
                </figure>
              <?php endforeach; ?>
            </div>
          <?php endif; ?>
        </div>
      </div>
    </section>
  </main>

  <footer>
    <p>&copy; <?= date('Y') ?> Kedai Salsabila &mdash; Dibuat dengan ❤️</p>
  </footer>

  <!-- ===== Lightbox ===== -->
  <div id="lightbox" class="lightbox" hidden>
    <div class="lb-backdrop" data-close></div>
    <figure class="lb-dialog">
      <button class="lb-close" type="button" aria-label="Tutup" data-close>&times;</button>
      <img id="lb-img" src="" alt="Pratinjau gambar">
      <figcaption id="lb-cap" class="lb-caption"></figcaption>
    </figure>
  </div>

  <script>
    // Buka lightbox saat klik "Lihat"
    document.querySelectorAll('[data-view-src]').forEach(function(el){
      el.addEventListener('click', function(e){
        e.preventDefault();
        const src = this.getAttribute('data-view-src');
        const cap = this.getAttribute('data-caption') || '';
        const lb  = document.getElementById('lightbox');
        document.getElementById('lb-img').src = src;
        document.getElementById('lb-cap').textContent = cap;
        lb.hidden = false;
        document.body.style.overflow = 'hidden';
      });
    });

    // Tutup lightbox (klik backdrop/close atau tekan ESC)
    function closeLB(){
      const lb = document.getElementById('lightbox');
      lb.hidden = true;
      document.getElementById('lb-img').src = '';
      document.body.style.overflow = '';
    }
    document.querySelectorAll('[data-close]').forEach(el => el.addEventListener('click', closeLB));
    document.addEventListener('keydown', function(e){ if(e.key === 'Escape'){ closeLB(); }});
  </script>
</body>
</html>
