<?php
require_once 'includes/db.php';

// Ambil kategori untuk filter
$kategori_filter_result = $conn->query("SELECT * FROM kategori ORDER BY nama_kategori ASC");

// Ambil semua iklan aktif (bisa > 1)
$sql_iklan = "SELECT * FROM iklan WHERE aktif = 1 ORDER BY id DESC";
$iklan_result = $conn->query($sql_iklan);
$iklan_list = [];
if ($iklan_result && $iklan_result->num_rows > 0) {
  while ($row = $iklan_result->fetch_assoc()) $iklan_list[] = $row;
}

// Helper aman
function e($str) { return htmlspecialchars((string)$str, ENT_QUOTES, 'UTF-8'); }
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Menu Kedai Salsabila

  </title>
  <meta name="description" content="Kedai Salsabilla - Makanan & Minuman khas, enak, harga bersahabat. Pesan langsung via WhatsApp." />

  <!-- BOOTSTRAP JS (untuk carousel) -->
  <script defer src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
  <link rel="icon" href="data:,">

  <style>
    :root{
      --primary:#ff6b35; --primary-dark:#e55a2b; --primary-light:#ff8960;
      --secondary:#ffd23f; --accent:#06d6a0;
      --dark:#0a0e27; --muted:#64748b; --muted-light:#94a3b8;
      --bg:#fafbfc; --card:#fff; --border:#e2e8f0; --border-light:#f1f5f9;
      --success:#10b981; --warning:#f59e0b;
      --shadow-sm:0 1px 3px rgba(0,0,0,.08);
      --shadow:0 4px 20px rgba(0,0,0,.08);
      --shadow-lg:0 10px 40px rgba(0,0,0,.12);
      --shadow-xl:0 24px 60px rgba(0,0,0,.16);
      --radius:20px; --radius-sm:12px; --radius-lg:24px;
      --header-height: 76px; --gap-section: 32px;
    }
    *{box-sizing:border-box}
    html,body{margin:0;padding:0;scroll-behavior:smooth}
    body{
      font-family:'Inter',system-ui,-apple-system,'Segoe UI',Roboto,Ubuntu,Cantarell,sans-serif;
      background:linear-gradient(135deg,#f5f7fa 0%,#c3cfe2 100%);
      color:var(--dark); line-height:1.6; font-size:16px; overflow-x:hidden;
    }
    body::before{
      content:''; position:fixed; inset:0; z-index:-1;
      background:
        radial-gradient(circle at 20% 80%, rgba(120,119,198,.28) 0%, transparent 50%),
        radial-gradient(circle at 80% 20%, rgba(255,107,53,.12) 0%, transparent 50%),
        radial-gradient(circle at 40% 40%, rgba(6,214,160,.10) 0%, transparent 50%);
      animation:float 20s ease-in-out infinite;
    }
    @keyframes float{0%,100%{transform:translateY(0) rotate(0)}33%{transform:translateY(-30px) rotate(1deg)}66%{transform:translateY(-18px) rotate(-1deg)}}
    .skip-link{position:absolute;left:-9999px;top:auto;width:1px;height:1px;overflow:hidden;z-index:9999}
    .skip-link:focus{left:20px;top:20px;width:auto;height:auto;background:#000;color:#fff;padding:12px 20px;border-radius:12px;font-weight:700}
    .container{max-width:1200px;margin:0 auto;padding:0 24px}

    /* Header */
    .site-header{
      position:sticky; top:0; z-index:1000;
      background:rgba(255,255,255,.95);
      backdrop-filter: blur(14px);
      border-bottom:1px solid var(--border-light);
      box-shadow:var(--shadow-sm);
      min-height:var(--header-height);
    }
    .nav{display:flex;align-items:center;justify-content:space-between;padding:14px 0;gap:16px}
    .brand{display:flex;gap:14px;align-items:center;font-weight:800;color:var(--primary);font-size:20px;letter-spacing:-.02em}
    .brand .logo{width:48px;height:48px;border-radius:12px;background:linear-gradient(135deg,var(--primary) 0%,var(--primary-light) 100%);display:grid;place-items:center;color:#fff;font-weight:900;box-shadow:var(--shadow);transform:perspective(1000px) rotateX(8deg)}
    .nav-cta{display:flex;gap:12px;align-items:center}
    .nav-cta a{text-decoration:none;font-weight:700;border-radius:50px;padding:12px 22px;border:2px solid var(--border);color:var(--dark);background:#fff;transition:.3s; display:inline-flex;align-items:center;gap:8px}
    .nav-cta a:hover{transform:translateY(-2px);box-shadow:var(--shadow)}
    .nav-cta a.primary{background:linear-gradient(135deg,var(--primary) 0%,var(--primary-light) 100%);color:#fff;border-color:transparent;box-shadow:var(--shadow)}
    .nav-cta a .dot{width:8px;height:8px;border-radius:50%;background:#22c55e;display:inline-block}

    /* Hero */
    .hero-spotlight {position: relative;margin: 24px 0 8px;background: linear-gradient(145deg, #fff 0%, #f8fafc 100%);border: 2px solid var(--border-light);border-radius: var(--radius-lg);box-shadow: var(--shadow-lg);overflow: hidden;}
    .hero-spotlight::before{content:"";position:absolute;top:0;left:0;right:0;height:5px;background:linear-gradient(90deg,var(--primary),var(--secondary),var(--accent),var(--primary));background-size:300% 100%;animation:shimmer 3s ease-in-out infinite}
    @keyframes shimmer{0%,100%{background-position:0% 50%}50%{background-position:100% 50%}}
    .hero-spotlight .wrap{display:grid;grid-template-columns:1.1fr 1fr;gap:32px;align-items:center;padding:clamp(24px,4vw,40px)}
    .hero-spotlight .copy h1{margin:0 0 16px 0;font-size:clamp(32px,5vw,64px);line-height:1.02;letter-spacing:-.03em;font-weight:900;background:linear-gradient(135deg,var(--dark) 0%,var(--primary) 70%,var(--accent) 100%);-webkit-background-clip:text;background-clip:text;-webkit-text-fill-color:transparent}
    .hero-spotlight .copy p{margin:0 0 24px 0;color:var(--muted);font-size:clamp(16px,2.2vw,20px);max-width:50ch;line-height:1.7}
    .hero-spotlight .cta{display:flex;gap:16px;flex-wrap:wrap;margin-top:8px}
    .hero-spotlight .cta .btn{border-radius:60px;padding:16px 28px;font-weight:800;text-decoration:none;transition:.3s ease;font-size:16px;position:relative;overflow:hidden}
    .hero-spotlight .cta .btn.primary{background:linear-gradient(135deg,var(--primary) 0%,var(--primary-light) 100%);color:#fff;box-shadow:var(--shadow-lg);border:0;position:relative}
    .hero-spotlight .cta .btn.primary::before{content:"";position:absolute;top:0;left:-100%;width:100%;height:100%;background:linear-gradient(90deg,transparent,rgba(255,255,255,.2),transparent);transition:left .5s ease}
    .hero-spotlight .cta .btn.primary:hover::before{left:100%}
    .hero-spotlight .cta .btn.ghost{background:rgba(255,255,255,.9);color:var(--dark);border:2px solid var(--border);backdrop-filter:blur(10px)}
    .hero-spotlight .cta .btn:hover{transform:translateY(-3px);box-shadow:var(--shadow-xl)}
    .hero-spotlight .visual{position:relative;aspect-ratio:4/3;border-radius:20px;overflow:hidden;isolation:isolate;background:linear-gradient(135deg,#f3f4f6 0%,#e5e7eb 100%);box-shadow:var(--shadow-lg)}
    .hero-spotlight .visual::before{content:"";position:absolute;width:80%;aspect-ratio:1/1;right:-8%;top:10%;border-radius:50%;background:linear-gradient(135deg,var(--secondary) 0%,var(--warning) 100%);z-index:0;filter:blur(1px);opacity:.8}
    .hero-spotlight .visual img{position:relative;z-index:1;width:100%;height:100%;object-fit:cover;transform:scale(1.02);transition:transform .4s ease}
    .hero-spotlight:hover .visual img{transform:scale(1.06) rotate(.5deg)}
    @media (max-width:900px){.hero-spotlight .wrap{grid-template-columns:1fr;gap:20px}.hero-spotlight .visual{order:-1}}

    /* Promo Section - Enhanced */
    .promo{margin:var(--gap-section) 0 16px}
    .promo-card{
      display:grid;grid-template-columns:1fr;gap:28px;
      background:linear-gradient(145deg,#fff 0%,#f8fafc 100%);
      border:2px solid var(--border-light);border-radius:var(--radius-lg);
      box-shadow:var(--shadow-lg);padding:28px;position:relative;overflow:hidden;
      transition:all .3s ease
    }
    .promo-card::before{content:"";position:absolute;left:0;top:0;right:0;height:6px;background:linear-gradient(90deg,var(--warning) 0%,var(--primary) 50%,var(--accent) 100%);background-size:300% 100%;animation:promoShimmer 2s ease-in-out infinite}
    @keyframes promoShimmer{0%,100%{background-position:0% 50%}50%{background-position:100% 50%}}
    .promo-card:hover{transform:translateY(-2px);box-shadow:var(--shadow-xl)}
    
    .promo-media{
      position:relative;overflow:hidden;border-radius:18px;aspect-ratio:16/9;
      background:var(--border-light);box-shadow:var(--shadow-lg);
      background:linear-gradient(135deg,#f1f5f9 0%,#e2e8f0 100%)
    }
    .promo-media img{width:100%;height:100%;object-fit:cover;display:block;transition:all .4s ease;max-height:500px}
    .promo-card:hover .promo-media img{transform:scale(1.08)}
    
    .promo-badge{
      position:absolute;left:20px;top:20px;
      background:linear-gradient(135deg,var(--warning) 0%,#f59e0b 100%);
      color:#fff;font-size:13px;font-weight:900;padding:10px 20px;
      border-radius:50px;letter-spacing:.08em;box-shadow:var(--shadow-lg);
      text-transform:uppercase;
      animation:pulse 2s infinite;
    }
    @keyframes pulse{0%,100%{transform:scale(1)}50%{transform:scale(1.05)}}
    
    .promo-body h3{margin:0 0 12px 0;font-size:28px;font-weight:900;color:var(--dark);line-height:1.2}
    .promo-body p{margin:0;color:var(--muted);font-size:16px;line-height:1.6}
    .promo-actions{margin-top:20px;display:flex;gap:16px;flex-wrap:wrap}
    .btn{appearance:none;border:none;border-radius:50px;padding:16px 28px;font-weight:800;cursor:pointer;text-decoration:none;transition:.3s ease;font-size:15px;position:relative;overflow:hidden}
    .btn.primary{background:linear-gradient(135deg,var(--primary) 0%,var(--primary-light) 100%);color:#fff;box-shadow:var(--shadow-lg)}
    .btn.primary::before{content:"";position:absolute;top:0;left:-100%;width:100%;height:100%;background:linear-gradient(90deg,transparent,rgba(255,255,255,.3),transparent);transition:left .6s ease}
    .btn.primary:hover::before{left:100%}
    .btn.ghost{background:rgba(255,255,255,.95);color:var(--dark);border:2px solid var(--border);backdrop-filter:blur(10px)}
    .btn:hover{transform:translateY(-2px);box-shadow:var(--shadow-xl)}

    /* Section Title - Enhanced */
    .section-title{display:flex;align-items:center;justify-content:center;gap:24px;margin:36px 0 20px 0;color:var(--dark)}
    .section-title .line{height:3px;background:linear-gradient(90deg,transparent,var(--primary),var(--accent),var(--primary),transparent);flex:1;max-width:150px;border-radius:2px}
    .section-title h2{margin:0;font-size:32px;font-weight:900;background:linear-gradient(135deg,var(--dark) 0%,var(--primary) 50%,var(--accent) 100%);-webkit-background-clip:text;background-clip:text;-webkit-text-fill-color:transparent;position:relative;padding:0 20px}
    .section-title h2::before{content:"";position:absolute;top:50%;left:50%;transform:translate(-50%,-50%);width:calc(100% + 40px);height:calc(100% + 20px);background:rgba(255,255,255,.9);border-radius:50px;z-index:-1;backdrop-filter:blur(10px)}

    /* Filter kategori - Enhanced */
    .filter-wrap{position:sticky; top: calc(var(--header-height) + 12px); z-index:900; background:transparent; margin:16px 0 12px}
    .filter{
      display:flex;gap:12px;overflow-x:auto;padding:16px 20px;border-radius:60px;
      background:rgba(255,255,255,.95);backdrop-filter:blur(20px);
      border:2px solid var(--border-light);box-shadow:var(--shadow-lg);
      -ms-overflow-style:none;scrollbar-width:none;
      position:relative
    }
    .filter::before{content:"";position:absolute;top:0;left:0;right:0;height:3px;background:linear-gradient(90deg,var(--primary),var(--secondary),var(--accent),var(--primary));border-radius:60px 60px 0 0;background-size:300% 100%;animation:filterShimmer 3s ease-in-out infinite}
    @keyframes filterShimmer{0%,100%{background-position:0% 50%}50%{background-position:100% 50%}}
    .filter::-webkit-scrollbar{display:none}
    .filter a{
      flex:0 0 auto;text-decoration:none;padding:14px 24px;border-radius:50px;
      border:2px solid var(--border-light);color:var(--dark);
      background:rgba(255,255,255,.9);font-weight:700;white-space:nowrap;
      transition:.3s ease;position:relative;overflow:hidden;
      backdrop-filter:blur(10px)
    }
    .filter a::before{content:"";position:absolute;top:0;left:-100%;width:100%;height:100%;background:linear-gradient(90deg,transparent,rgba(255,255,255,.4),transparent);transition:left .5s ease}
    .filter a:hover::before{left:100%}
    .filter a:hover{transform:translateY(-3px);box-shadow:var(--shadow-lg);border-color:var(--primary)}
    .filter a.active{
      background:linear-gradient(135deg,var(--primary) 0%,var(--primary-light) 100%);
      border-color:var(--primary);color:#fff;box-shadow:var(--shadow-lg);
      transform:translateY(-2px)
    }
    .filter a.active::before{content:"";background:linear-gradient(90deg,transparent,rgba(255,255,255,.3),transparent)}

    #product-display-title{margin:24px 0 16px 0}
    #judul-kategori{
      display:inline-block;padding:12px 24px;border-radius:50px;
      background:linear-gradient(135deg,#fff 0%,#f8fafc 100%);
      border:2px solid var(--border-light);box-shadow:var(--shadow);
      font-weight:800;color:var(--dark);position:relative;
      backdrop-filter:blur(10px)
    }
    #judul-kategori::before{content:"";position:absolute;top:-2px;left:-2px;right:-2px;bottom:-2px;background:linear-gradient(135deg,var(--primary),var(--accent),var(--secondary));border-radius:50px;z-index:-1}

    /* GRID PRODUK — Enhanced */
    #product-grid-container{min-height:300px;transition:opacity .4s ease, filter .4s ease;opacity:1; margin-top:16px;position:relative;z-index:1}
    #product-grid-container.loading{opacity:.4;filter:blur(.5px)}
    .product-grid{display:grid;gap:24px;grid-template-columns:repeat(auto-fill,minmax(280px,1fr))}
    .product-grid .product-card-link{opacity:0;transform:translateY(30px);animation:cardSlideIn .7s ease-out forwards}
    @keyframes cardSlideIn{to{opacity:1;transform:translateY(0)}}

    .product-grid .card{
      background:linear-gradient(145deg,#fff 0%,#f8fafc 100%);
      border:2px solid var(--border-light);border-radius:20px;
      box-shadow:var(--shadow);overflow:hidden;display:flex;
      flex-direction:column;transition:.3s ease;position:relative
    }
    .product-grid .card:hover{transform:translateY(-6px);box-shadow:var(--shadow-xl);border-color:var(--primary)}

    /* MEDIA – Enhanced */
    .product-grid .card .media{aspect-ratio:4/3;height:auto;background:linear-gradient(135deg,#fff 0%,#f9fafb 100%);position:relative;overflow:hidden}
    .product-grid .card .media img{width:100%;height:100%;object-fit:contain;padding:12px;background:#fff;display:block;transition:transform .3s ease}
    .product-grid .card:hover .media img{transform:scale(1.05)}

    .category-badge{
      position:absolute;top:16px;left:16px;color:#fff;font-size:12px;
      font-weight:800;padding:6px 12px;border-radius:20px;
      text-transform:uppercase;letter-spacing:.6px;
      box-shadow:var(--shadow);backdrop-filter:blur(10px)
    }
    .rating-overlay{
      position:absolute;top:16px;right:16px;
      background:rgba(255,255,255,.95);backdrop-filter:blur(10px);
      padding:6px 10px;border-radius:16px;box-shadow:var(--shadow-sm)
    }
    .stars{display:flex;gap:2px;font-size:14px}.star.filled{color:#fbbf24}.star.empty{color:#d1d5db}

    .product-grid .card .body{padding:20px;display:flex;flex-direction:column;gap:8px}
    .product-grid .card .body h4{margin:0;font-size:18px;font-weight:900;color:#111827;display:-webkit-box;-webkit-line-clamp:1;-webkit-box-orient:vertical;overflow:hidden}
    .product-grid .card .desc{font-size:14px;color:#64748b;min-height:48px;display:-webkit-box;-webkit-line-clamp:2;-webkit-box-orient:vertical;overflow:hidden;line-height:1.5}
    .price-section{display:flex;align-items:center;justify-content:space-between;margin-top:auto;gap:12px}
    .price{font-weight:900;color:var(--primary);font-size:20px;letter-spacing:-.02em}

    .quick-actions{display:flex;gap:10px;opacity:0;transform:translateY(8px);transition:all .3s ease}
    .card:hover .quick-actions{opacity:1;transform:translateY(0)}
    .quick-btn{
      width:40px;height:40px;border:none;border-radius:12px;
      background:rgba(241,245,249,.9);color:#64748b;cursor:pointer;
      display:flex;align-items:center;justify-content:center;
      transition:all .3s ease;backdrop-filter:blur(10px)
    }
    .quick-btn:hover{transform:scale(1.1)}
    .cart-btn:hover{background:linear-gradient(135deg,var(--primary),var(--primary-light));color:#fff;box-shadow:var(--shadow)}
    .whatsapp-btn:hover{background:linear-gradient(135deg,var(--success),#34d399);color:#fff;box-shadow:var(--shadow)}

    /* Skeleton - Enhanced */
    .skeleton-grid{display:grid;gap:24px;grid-template-columns:repeat(auto-fill,minmax(280px,1fr))}
    .sk-card{border-radius:20px;border:2px solid var(--border-light);background:linear-gradient(145deg,#fff 0%,#f8fafc 100%);overflow:hidden}
    .sk-media{height:200px;background:linear-gradient(90deg,#f1f5f9 25%,#e2e8f0 37%,#f1f5f9 63%);background-size:400% 100%;animation:shimmerSk 1.5s infinite}
    .sk-body{padding:20px}.sk-line{height:16px;border-radius:8px;margin:10px 0;background:linear-gradient(90deg,#f1f5f9 25%,#e2e8f0 37%,#f1f5f9 63%);background-size:400% 100%;animation:shimmerSk 1.5s infinite}
    .sk-price{width:65%;height:20px;border-radius:10px;background:linear-gradient(90deg,#f1f5f9 25%,#e2e8f0 37%,#f1f5f9 63%);background-size:400% 100%;animation:shimmerSk 1.5s infinite}
    @keyframes shimmerSk{0%{background-position:200% 0}100%{background-position:-200% 0}}

    /* CTA + footer + WA - Enhanced */
    .cta{
      margin:calc(var(--gap-section) + 12px) 0;
      background:linear-gradient(145deg,#fff 0%,#f8fafc 100%);
      border:2px solid var(--border-light);border-radius:var(--radius-lg);
      box-shadow:var(--shadow-lg);padding:32px;display:grid;gap:16px;
      text-align:center;position:relative;overflow:hidden
    }
    .cta::before{content:"";position:absolute;left:0;top:0;right:0;height:6px;background:linear-gradient(90deg,var(--accent),var(--primary),var(--secondary),var(--accent));background-size:300% 100%;animation:ctaShimmer 2.5s ease-in-out infinite}
    @keyframes ctaShimmer{0%,100%{background-position:0% 50%}50%{background-position:100% 50%}}
    .cta h2{margin:0 0 8px 0;font-size:32px;font-weight:900;color:var(--dark)}
    .cta .info{color:var(--muted);font-size:18px;line-height:1.6}
    .contact{display:flex;flex-direction:column;gap:8px;align-items:center;color:var(--dark);font-weight:600;font-size:16px}
    .contact a{color:var(--primary);text-decoration:none;font-weight:800}
    .contact a:hover{text-decoration:underline}
    .cta .cta-btn{
      margin-top:16px;display:inline-block;text-decoration:none;
      background:linear-gradient(135deg,var(--success) 0%,#34d399 100%);
      color:#fff;padding:18px 36px;border-radius:60px;font-weight:900;
      box-shadow:var(--shadow-lg);transition:.3s ease;font-size:18px;
      position:relative;overflow:hidden
    }
    .cta .cta-btn::before{content:"";position:absolute;top:0;left:-100%;width:100%;height:100%;background:linear-gradient(90deg,transparent,rgba(255,255,255,.3),transparent);transition:left .6s ease}
    .cta .cta-btn:hover::before{left:100%}
    .cta .cta-btn:hover{transform:translateY(-4px);box-shadow:var(--shadow-xl)}
    
    footer{margin:40px 0 24px 0;color:var(--muted);text-align:center;font-weight:600;font-size:15px}

    .wa-fab{
      position:fixed;right:28px;bottom:28px;z-index:1200;
      background:linear-gradient(135deg,var(--success) 0%,#34d399 100%);
      color:#fff;border-radius:60px;padding:16px 20px;text-decoration:none;
      font-weight:900;box-shadow:var(--shadow-xl);transition:.3s ease;
      font-size:15px
    }
    .wa-fab:hover{transform:scale(1.08);box-shadow:0 25px 60px rgba(16,185,129,.4)}
    .wa-fab{animation:bounce 2s infinite;will-change:transform}
    @keyframes bounce{0%,20%,53%,80%,100%{transform:translate3d(0,0,0)}40%,43%{transform:translate3d(0,-10px,0)}70%{transform:translate3d(0,-5px,0)}90%{transform:translate3d(0,-2px,0)}}

    @media (min-width:1280px){ .product-grid{ grid-template-columns: repeat(5,1fr);} }
    @media (max-width:768px){
      .nav{gap:10px}.nav-cta{gap:8px}.nav-cta a{padding:10px 14px;font-size:14px}
      .hero-spotlight .wrap{grid-template-columns:1fr;gap:16px}.hero-spotlight .visual{order:-1}
      .filter{padding:12px 16px}.filter a{padding:12px 18px;font-size:14px}
      .product-grid,.skeleton-grid{grid-template-columns:repeat(auto-fill,minmax(240px,1fr));gap:16px}
      #product-display-title{margin:20px 0 12px 0} #product-grid-container{margin-top:12px}
      .quick-actions{opacity:1;transform:none}
      .section-title h2{font-size:26px}.section-title{gap:16px}
      .promo-card{padding:20px;gap:20px}
      .cta{padding:24px}.cta h2{font-size:26px}
    }

    /* Carousel controls - Enhanced */
    .carousel{position:relative}
    .carousel-inner{position:relative;overflow:hidden;border-radius:20px}
    .carousel-item{display:none;position:relative;transition:transform .8s ease-in-out}
    .carousel-item.active{display:block}
    .carousel-indicators{display:flex;gap:12px;justify-content:center;margin:16px 0 0;padding:0;list-style:none}
    .carousel-indicators [data-bs-target]{
      width:12px;height:12px;border-radius:50%;border:0;
      background:rgba(148,163,184,.6);cursor:pointer;
      transition:all .3s ease;box-shadow:var(--shadow-sm)
    }
    .carousel-indicators [data-bs-target]:hover{transform:scale(1.2);background:rgba(255,107,53,.7)}
    .carousel-indicators .active{background:linear-gradient(135deg,var(--primary),var(--primary-light));transform:scale(1.3);box-shadow:var(--shadow)}
    .carousel-control-prev,.carousel-control-next{
      position:absolute;bottom:12px;width:auto;top:auto;
      background:rgba(255,255,255,.95);border-radius:50px;
      padding:12px 14px;box-shadow:var(--shadow);border:0;
      transition:all .3s ease;backdrop-filter:blur(10px)
    }
    .carousel-control-prev:hover,.carousel-control-next:hover{transform:scale(1.1);box-shadow:var(--shadow-lg)}
    .carousel-control-prev{left:12px}.carousel-control-next{right:12px}
    .carousel-control-prev-icon,.carousel-control-next-icon{
      display:inline-block;width:20px;height:20px;
      background-repeat:no-repeat;background-size:contain
    }
    .carousel-control-prev-icon{background-image:url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='%23ff6b35'%3e%3cpath d='M11.354 1.646a.5.5 0 0 1 0 .708L5.707 8l5.647 5.646a.5.5 0 0 1-.708.708l-6-6a.5.5 0 0 1 0-.708l6-6a.5.5 0 0 1 .708 0z'/%3e%3c/svg%3e")}
    .carousel-control-next-icon{background-image:url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='%23ff6b35'%3e%3cpath d='M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z'/%3e%3c/svg%3e")}
    
  </style>
</head>
<body>
  <a href="#konten" class="skip-link">Loncat ke konten utama</a>

  <header class="site-header" role="banner">
    <div class="container nav" aria-label="Navigasi utama">
      <div class="brand">
        <div class="logo">KS</div>
        <div>Kedai Salsabila</div>
      </div>
      <div class="nav-cta">
        <a href="#menu">Lihat Menu</a>
        
  </header>

  <main id="konten" class="container" role="main">
    <!-- HERO -->
    <section class="hero-spotlight" aria-label="Profil Kedai">
      <div class="wrap">
        <div class="copy">
          <h1>Kedai Salsabilla <br/></h1>
          <p>Kedai Salsabila menyediakan berbagai kebutuhan anda, dari bahan pokok hingga perlengkapan sehari-hari, dengan harga terjangkau dan pelayanan yang ramah.</p>
          <div class="cta">
            <a class="btn primary" href="#menu">Lihat Menu</a>
            <a class="btn ghost" href="profil.php" target="_blank" rel="noopener">Lihat Detail Kedai </a>
          </div>
        </div>
        <div class="visual" role="img" aria-label="Foto Kedai Salsabilla">
          <img src="uploads/warung.jpg"
               alt="Suasana Kedai Salsabilla"
               loading="eager"
               onerror="this.src='data:image/svg+xml,&lt;svg xmlns=%22http://www.w3.org/2000/svg%22 width=%22800%22 height=%22600%22&gt;&lt;rect width=%22100%25%22 height=%22100%25%22 fill=%22%23f1f5f9%22/&gt;&lt;text x=%2250%25%22 y=%2250%25%22 dominant-baseline=%22middle%22 text-anchor=%22middle%22 fill=%22%2394a3b8%22 font-size=%2222%22 font-family=%22Arial%22&gt;Upload foto kedai (uploads/hero-warung.jpg)&lt;/text&gt;&lt;/svg&gt;';">
        </div>
      </div>
    </section>

    <!-- PROMO -->
    <section class="promo" aria-labelledby="promo-title">
      <div class="section-title">
        <span class="line"></span><h2 id="promo-title">✨ Promosi Spesial Hari Ini ✨</h2><span class="line"></span>
      </div>

      <?php if (count($iklan_list) === 0): ?>
        <div style="text-align:center;padding:60px 20px;background:linear-gradient(145deg,#fff 0%,#f8fafc 100%);border:2px solid var(--border-light);border-radius:var(--radius-lg);box-shadow:var(--shadow)">
          <div style="margin:0 auto 20px;opacity:.6">
            <svg width="80" height="80" viewBox="0 0 24 24" fill="none" stroke="#94a3b8" stroke-width="1">
              <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
            </svg>
          </div>
          <h3 style="margin:0 0 12px;font-size:24px;color:var(--muted);font-weight:700">Belum ada promosi untuk hari ini</h3>
          <p style="margin:0;color:var(--muted-light);font-size:16px">Nantikan promosi menarik dari kami! 🎉</p>
        </div>

      <?php elseif (count($iklan_list) === 1):
        $ik = $iklan_list[0]; ?>
        <article class="promo-card" aria-label="Kartu promosi">
          <div class="promo-media">
            <span class="promo-badge" aria-hidden="true">🎉 PROMO SPESIAL</span>
            <img src="<?='uploads/'.e($ik['gambar']);?>" alt="<?=e($ik['judul']);?>" loading="lazy"/>
          </div>
          <div class="promo-body">
            <h3><?=e($ik['judul']);?></h3>
            <p><?=nl2br(e($ik['deskripsi']));?></p>
            <div class="promo-actions">
              <a class="btn primary" href="https://wa.me/6283821470781?text=Halo,%20saya%20tertarik%20promo:%20<?=rawurlencode($ik['judul']);?>" target="_blank" rel="noopener">🛒 Pesan Promo</a>
              <a class="btn ghost" href="#menu">📋 Lihat Semua Menu</a>
            </div>
          </div>
        </article>

      <?php else: ?>
        <!-- Carousel jika iklan > 1 -->
        <div id="promoCarousel" class="carousel slide" data-bs-ride="carousel" data-bs-interval="5000">
          <div class="carousel-indicators">
            <?php foreach ($iklan_list as $i => $row): ?>
              <button type="button" data-bs-target="#promoCarousel" data-bs-slide-to="<?=$i?>" <?=$i===0?'class="active" aria-current="true"':''?> aria-label="Slide <?=$i+1?>"></button>
            <?php endforeach; ?>
          </div>

          <div class="carousel-inner">
            <?php foreach ($iklan_list as $i => $ik): ?>
              <div class="carousel-item <?=$i===0?'active':''?>">
                <article class="promo-card">
                  <div class="promo-media">
                    <span class="promo-badge">🎉 PROMO SPESIAL</span>
                    <img src="<?='uploads/'.e($ik['gambar']);?>" alt="<?=e($ik['judul']);?>" loading="lazy"/>
                  </div>
                  <div class="promo-body">
                    <h3><?=e($ik['judul']);?></h3>
                    <p><?=nl2br(e($ik['deskripsi']));?></p>
                    <div class="promo-actions">
                      <a class="btn primary" href="https://wa.me/6283821470781?text=Halo,%20saya%20tertarik%20promo:%20<?=rawurlencode($ik['judul']);?>" target="_blank" rel="noopener">🛒 Pesan Promo</a>
                      <a class="btn ghost" href="#menu">📋 Lihat Semua Menu</a>
                    </div>
                  </div>
                </article>
              </div>
            <?php endforeach; ?>
          </div>

          <button class="carousel-control-prev" type="button" data-bs-target="#promoCarousel" data-bs-slide="prev" aria-label="Sebelumnya">
            <span class="carousel-control-prev-icon" aria-hidden="true"></span>
          </button>
          <button class="carousel-control-next" type="button" data-bs-target="#promoCarousel" data-bs-slide="next" aria-label="Berikutnya">
            <span class="carousel-control-next-icon" aria-hidden="true"></span>
          </button>
        </div>
      <?php endif; ?>
    </section>

    <!-- FILTER + GRID PRODUK -->
    <section id="menu" class="menu-section" aria-labelledby="menu-title">
      <div class="section-title"><span class="line"></span><h2 id="menu-title">🍽️ Pilih Kategori Menu</h2><span class="line"></span></div>

      <div class="filter-wrap">
        <nav class="filter" aria-label="Filter kategori" id="filter-kategori">
          <a href="?kategori_id=all" data-kategori-id="all" class="filter-btn active">🍽️ Semua Kategori</a>
          <?php if ($kategori_filter_result && $kategori_filter_result->num_rows > 0): ?>
            <?php while($kat = $kategori_filter_result->fetch_assoc()): ?>
              <a href="?kategori_id=<?= (int)$kat['id']; ?>" data-kategori-id="<?= (int)$kat['id']; ?>" class="filter-btn"><?= e($kat['nama_kategori']); ?></a>
            <?php endwhile; ?>
          <?php endif; ?>
        </nav>
      </div>

      <h3 id="product-display-title" class="section-title" style="gap:16px">
        <span class="line"></span>
        <span id="judul-kategori" style="margin:0">Menampilkan: Semua Kategori</span>
        <span class="line"></span>
      </h3>

      <div id="product-grid-container" aria-live="polite" aria-busy="false"></div>
    </section>

    <!-- CTA -->
    <section class="cta" aria-labelledby="cta-title">
      <h2 id="cta-title" style="margin:0">🤔 Tertarik Mencoba?</h2>
      <p class="info">Jangan ragu untuk datang langsung ke Kedai kami atau pesan melalui WhatsApp!</p>
      <div class="contact" role="contentinfo">
        <div>📍 Desa ciawi, kec.Wanayasa, Kab.Purwakarta</div>
        <div>📞 WhatsApp: <a href="https://wa.me/6283821470781" target="_blank" rel="noopener">083821470781</a></div>
        <div>🕒 Buka Setiap Hari: 06:00 - 23:00</div>
      </div>
      <a class="cta-btn" href="https://wa.me/6283821470781?text=Halo,%20saya%20mau%20pesan%20menu%20dari%20Kedai%20%20Salsabilla" target="_blank" rel="noopener">🚀 Pesan Sekarang!</a>
    </section>
  </main>

  <footer>
    <p>&copy; <?= date("Y"); ?> Kedai Salsabilla. All Rights Reserved.</p>
  </footer>

  <!-- Floating WA -->
  <a class="wa-fab" href="https://wa.me/6283817724184?text=Halo,%20saya%20mau%20pesan%20menu%20dari%20Kedai%20%20Salsabilla" target="_blank" rel="noopener" aria-label="Pesan via WhatsApp">💬 Pesan via WA</a>

<script>
  // --- Skeleton tetap boleh dipakai ---
  function renderSkeleton(n=8){
    const wrap=document.createElement('div');wrap.className='skeleton-grid';
    let s='';for(let i=0;i<n;i++){s+=`<div class="sk-card"><div class="sk-media"></div><div class="sk-body">
    <div class="sk-line" style="width:85%"></div><div class="sk-line" style="width:65%"></div><div class="sk-price"></div></div></div>`}
    wrap.innerHTML=s; return wrap.outerHTML;
  }

  document.addEventListener('DOMContentLoaded', ()=>{
    const filterButtons = document.querySelectorAll('.filter-btn');
    const productContainer = document.getElementById('product-grid-container');
    const titleEl = document.getElementById('judul-kategori');

    // Ubah ini kalau mau batas per halaman berbeda
    const PER_PAGE = 6; // set 6 kalau mau 6 item/halaman

    function setActiveButton(id){
      filterButtons.forEach(btn => btn.classList.toggle('active', btn.getAttribute('data-kategori-id')===id));
    }

    async function loadProducts(kategoriId, kategoriNama, pushUrl=true, page=1){
      titleEl.textContent = 'Menampilkan: ' + kategoriNama;
      productContainer.setAttribute('aria-busy','true');
      productContainer.classList.add('loading');
      productContainer.innerHTML = renderSkeleton(PER_PAGE);

      const params = new URLSearchParams();
      if (kategoriId !== 'all') params.set('kategori_id', kategoriId);
      if (page > 1) params.set('page', page);
      if (PER_PAGE) params.set('per_page', PER_PAGE);

      const url = 'admin/get_produk.php' + (params.toString() ? ('?'+params.toString()) : '');

      try{
        const res = await fetch(url, { headers:{'X-Requested-With':'fetch'} });
        if (!res.ok) throw new Error('Gagal memuat data ('+res.status+')');
        const html = await res.text();
        productContainer.innerHTML = (html||'').trim() || '<div style="text-align:center;padding:80px 20px;background:linear-gradient(145deg,#fff 0%,#f8fafc 100%);border:2px solid var(--border-light);border-radius:var(--radius-lg);box-shadow:var(--shadow)"><h3 style="margin:0 0 12px;font-size:22px;color:#64748b;font-weight:700">Belum ada produk</h3><p style="margin:0;color:#94a3b8;font-size:16px">Produk untuk kategori ini belum tersedia.</p></div>';

        // fallback gambar
        productContainer.querySelectorAll('img').forEach(img=>{
          img.loading='lazy';
          img.addEventListener('error', ()=>{
            img.src='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" width="600" height="400"><rect width="100%" height="100%" fill="%23f1f5f9"/><text x="50%" y="50%" dominant-baseline="middle" text-anchor="middle" fill="%2364748b" font-size="16" font-family="Arial">Gambar tidak tersedia</text></svg>';
          });
        });

        // Handle klik pagination (dipasang ulang setiap render)
        const pager = productContainer.querySelector('.product-pagination');
        if (pager) {
          pager.addEventListener('click', (e)=>{
            const a = e.target.closest('a.page-link[data-page]');
            if (!a) return;
            e.preventDefault();
            const nextPage = parseInt(a.getAttribute('data-page'),10) || 1;
            loadProducts(kategoriId, kategoriNama, true, nextPage);
          }, { once:true });
        }

      }catch(err){
        console.error(err);
        productContainer.innerHTML = '<div style="text-align:center;padding:80px 20px;background:linear-gradient(145deg,#fff 0%,#f8fafc 100%);border:2px solid #e2e8f0;border-radius:20px;box-shadow:0 10px 40px rgba(0,0,0,.08)"><h3 style="margin:0 0 12px;font-size:22px;color:#ef4444;font-weight:800">Gagal memuat produk</h3><p style="margin:0;color:#64748b;font-size:16px">Silakan coba lagi.</p></div>';
      }finally{
        productContainer.classList.remove('loading');
        productContainer.setAttribute('aria-busy','false');
      }

      // Sinkron URL agar bisa Back/Forward
      if (pushUrl){
        const q = new URLSearchParams();
        if (kategoriId !== 'all') q.set('kategori_id', kategoriId);
        if (page > 1) q.set('page', page);
        history.pushState({kategoriId, kategoriNama, page}, '', location.pathname + (q.toString()?('?'+q.toString()):'') + '#menu');
      }
    }

    // Klik filter kategori
    filterButtons.forEach(btn=>{
      btn.addEventListener('click', (ev)=>{
        ev.preventDefault();
        const id = btn.getAttribute('data-kategori-id');
        const nama = btn.textContent.trim();
        setActiveButton(id);
        loadProducts(id, nama, true, 1); // reset ke halaman 1 saat ganti kategori
      });
    });

    // Init pertama kali (baca URL ?kategori_id & ?page)
    const params = new URLSearchParams(location.search);
    const initialId = params.get('kategori_id') || 'all';
    const initialPage = parseInt(params.get('page') || '1', 10);
    const initialBtn = [...filterButtons].find(b => b.getAttribute('data-kategori-id')===initialId) || filterButtons[0];
    const initialName = initialBtn ? initialBtn.textContent.trim() : 'Semua Kategori';
    setActiveButton(initialId);
    loadProducts(initialId, initialName, false, initialPage);

    // Back/Forward browser
    window.addEventListener('popstate', ()=>{
      const p = new URLSearchParams(location.search);
      const pid   = p.get('kategori_id') || 'all';
      const ppage = parseInt(p.get('page') || '1', 10);
      const pbtn  = [...filterButtons].find(b => b.getAttribute('data-kategori-id')===pid) || filterButtons[0];
      const pname = pbtn ? pbtn.textContent.trim() : 'Semua Kategori';
      setActiveButton(pid);
      loadProducts(pid, pname, false, ppage);
    });
  });
</script>

</body>
</html>