<?php
// includes/header_admin.php
if (session_status() === PHP_SESSION_NONE) session_start();
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__.'/db.php';
require_once __DIR__.'/../admin/auth.php';

if (!function_exists('e')) {
  function e($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
}

$current_page = basename($_SERVER['SCRIPT_NAME']);
$page_title   = $page_title ?? 'Admin Panel';
$breadcrumb   = $breadcrumb ?? null;

/* CSRF token untuk form Offcanvas */
if (empty($_SESSION['csrf_token'])) {
  $_SESSION['csrf_token'] = bin2hex(random_bytes(16));
}
$csrf_token = $_SESSION['csrf_token'];

/* Ambil produk utk dropdown sidebar */
$produk_options = [];
$qp = $conn->query("SELECT id, nama_produk, stok FROM produk ORDER BY nama_produk ASC");
if ($qp) {
  while ($row = $qp->fetch_assoc()) {
    $produk_options[] = $row;
  }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width,initial-scale=1.0">
  <title><?= e($page_title) ?> - Kedai Salsabilla</title>

  <!-- Bootstrap 5 -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <script defer src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

  <!-- Font Awesome -->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" rel="stylesheet"/>

  <!-- Styles admin -->
  <link rel="stylesheet" href="../assets/admin.css?v=7">

  <style>
    .admin-shell{display:flex; min-height:100vh; width:100%;}
    .admin-aside{flex:0 0 260px;}
    .admin-main{flex:1 1 auto; min-width:0; display:flex; flex-direction:column; width:100%;}
    .admin-topbar{position:sticky; top:0; z-index:100; background:#fff; border-bottom:1px solid rgba(0,0,0,.06); padding:10px 16px; display:flex; align-items:center; gap:12px; justify-content:space-between;}
    .admin-burger{border:0; background:transparent; font-size:20px; line-height:1; padding:6px 8px}
    .admin-title{font-weight:700}

    .admin-content,
    .container, .container-sm, .container-md, .container-lg, .container-xl, .container-xxl,
    .content, .content-wrapper, .page-content, .app-content, .wrapper, .main-content {
      max-width: 100% !important;
      width: 100% !important;
    }
    .admin-content{padding:20px 24px;}

    .breadcrumb{margin:0 0 12px 0; padding:6px 0; color:#6b7280; font-size:.925rem;}

    @media (max-width: 992px){
      .admin-aside{position:fixed; z-index:120; left:-280px; top:0; bottom:0; width:260px; background:#0f172a; color:#fff; transition:left .2s ease;}
      .admin-aside.show{left:0;}
    }

    .admin-nav{display:flex;flex-direction:column;gap:4px;padding:0 12px;}
    .admin-nav a{display:flex; align-items:center; gap:10px; color:#e2e8f0; padding:10px 12px; border-radius:10px; text-decoration:none;}
    .admin-nav a.active, .admin-nav a:hover{background:#0b1228; color:#fff;}
    /* Tonjolkan menu Stok & Transaksi sedikit */
    .admin-nav a#openInventoryLink i { color:#ff7b54; }
    .admin-nav a#openInventoryLink:hover { background:#0b1228; }

    /* Offcanvas width util (digunakan di footer) */
    .custom-offcanvas{width:420px; max-width:92vw;}
  </style>
</head>
<body>
  <div class="admin-shell">
    <!-- Sidebar -->
    <aside id="adminAside" class="admin-aside" aria-label="Sidebar admin">
      <div class="admin-brand" style="display:flex;align-items:center;gap:10px;padding:16px;">
        <div class="admin-logo" style="width:34px;height:34px;border-radius:10px;background:#ff7b54;color:#fff;display:flex;align-items:center;justify-content:center;font-weight:800">KS</div>
        <strong>Kedai Salsabilla</strong>
      </div>

      <nav class="admin-nav">
        <a href="dashboard.php" class="<?= $current_page==='dashboard.php'?'active':'';?>">
          <i class="fa-solid fa-gauge"></i><span>Dashboard</span>
        </a>
        <a href="kategori.php"  class="<?= $current_page==='kategori.php'?'active':'';?>">
          <i class="fa-solid fa-folder-tree"></i><span>Kategori</span>
        </a>
        <a href="produk.php"    class="<?= $current_page==='produk.php'?'active':'';?>">
          <i class="fa-solid fa-boxes-stacked"></i><span>Produk</span>
        </a>

        <!-- === MENU BARU: Stok & Transaksi (buka offcanvas) === -->
     <a href="stok_transaksi.php" class="<?= $current_page==='stok_transaksi.php'?'active':'';?>">
  <i class="fa-solid fa-clipboard-list"></i><span>Stok & Transaksi</span>
</a>


        <a href="iklan.php"     class="<?= $current_page==='iklan.php'?'active':'';?>">
          <i class="fa-solid fa-bullhorn"></i><span>Iklan</span>
        </a>
        <a href="profil.php"    class="<?= $current_page==='profil.php'?'active':'';?>">
          <i class="fa-solid fa-user"></i><span>Profil</span>
        </a>
      </nav>

      <div style="flex:1"></div>
      <div style="padding:12px;">
        <a href="logout.php" class="btn btn-danger w-100">Logout</a>
      </div>
    </aside>

    <!-- Overlay (untuk mobile) -->
    <div id="adminOverlay" class="admin-overlay" role="presentation" style="position:fixed;inset:0;background:rgba(0,0,0,.35);opacity:0;visibility:hidden;transition:.2s;z-index:90;"></div>

    <!-- Main -->
    <section class="admin-main">
      <div class="admin-topbar">
        <div class="d-flex align-items-center gap-2">
          <button id="burgerBtn" class="admin-burger" aria-label="Toggle sidebar">
            <i class="fa-solid fa-bars"></i>
          </button>
          <div class="admin-title"><?= e($page_title) ?></div>
        </div>
        <div class="d-flex align-items-center gap-2">
          <a class="btn btn-sm btn-outline-secondary" href="../index.php" target="_blank" rel="noopener">
            Lihat Situs
          </a>
          <!-- Tidak ada tombol Stok & Transaksi di topbar agar fokus di sidebar -->
        </div>
      </div>

      <main class="admin-content">
        <?php if (!empty($breadcrumb)): ?>
          <div class="breadcrumb"><?= $breadcrumb; ?></div>
        <?php endif; ?>
