<?php
// includes/header_admin.php (FINAL - simpan isi file persis ini)
if (session_status() === PHP_SESSION_NONE) session_start();

ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__.'/db.php';
require_once __DIR__.'/../admin/auth.php';

if (!function_exists('e')) {
  function e($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
}

$current_page = basename($_SERVER['SCRIPT_NAME']);
$page_title   = $page_title ?? 'Admin Panel';
$breadcrumb   = $breadcrumb ?? null;
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width,initial-scale=1.0">
  <title><?= e($page_title) ?> - Kedai Salsabilla</title>
  <link rel="stylesheet" href="../assets/admin.css?v=4">
</head>
<body>
  <div class="admin-shell">
    <!-- Sidebar -->
    <aside id="adminAside" class="admin-aside" aria-label="Sidebar admin">
      <div class="admin-brand">
        <div class="admin-logo">KS</div>
        <strong>Kedai Salsabilla</strong>
      </div>

      <nav class="admin-nav">
        <a href="dashboard.php" class="<?= $current_page==='dashboard.php'?'active':'';?>">📊 <span>Dashboard</span></a>
        <a href="kategori.php"  class="<?= $current_page==='kategori.php'?'active':'';?>">🏷️ <span>Kategori</span></a>
        <a href="produk.php"    class="<?= $current_page==='produk.php'?'active':'';?>">🍽️ <span>Prddduk</span></a>
        <a href="iklan.php"     class="<?= $current_page==='iklan.php'?'active':'';?>">🎉 <span>Iklan</span></a>
      </nav>

      <div class="admin-spacer"></div>
      <div class="admin-logout">
        <a href="logout.php">Logout</a>
      </div>
    </aside>

    <!-- Overlay mobile -->
    <div id="adminOverlay" class="admin-overlay" role="presentation"></div>

    <!-- Main -->
    <section class="admin-main">
      <div class="admin-topbar">
        <button id="burgerBtn" class="admin-burger" aria-label="Toggle sidebar">☰</button>
        <div class="admin-title"><?= e($page_title) ?></div>
        <div class="admin-actions">
          <a class="btn" href="../index.php" target="_blank" rel="noopener">Lihat Situs</a>
        </div>
      </div>

      <main class="admin-content">
        <?php if (!empty($breadcrumb)): ?>
          <div class="breadcrumb"><?= $breadcrumb; ?></div>
        <?php endif; ?>
