<?php
// admin/stok_transaksi.php
if (session_status() === PHP_SESSION_NONE) session_start();
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/auth.php';

$page_title = 'Stok & Transaksi';
$breadcrumb = 'Admin / Stok & Transaksi';

if (empty($_SESSION['csrf_token'])) $_SESSION['csrf_token'] = bin2hex(random_bytes(16));
$csrf_token = $_SESSION['csrf_token'];

require_once __DIR__ . '/../includes/header_admin.php'; // e() sudah tersedia dari header
?>
<style>
  .box{background:rgba(255,255,255,.9);border:1px solid rgba(255,255,255,.6);border-radius:22px;box-shadow:0 24px 60px rgba(21,23,42,.08);}
  .table img.thumb{width:56px;height:56px;object-fit:cover;border-radius:10px;border:2px solid #eef2f7;}
  .badge-pill{border-radius:999px;padding:.25rem .55rem}
</style>

<div class="row g-4">
  <!-- ================== TABEL PRODUK ================== -->
  <div class="col-12">
    <div class="box p-3 p-md-4">
      <div class="d-flex justify-content-between align-items-center mb-3">
        <h2 class="h5 fw-bold m-0"><i class="fa-solid fa-boxes-stacked me-2"></i>Daftar Produk</h2>
        <div class="d-flex gap-2">
          <input id="qProduk" class="form-control form-control-sm" placeholder="Cari produk/kategori…">
          <select id="perProduk" class="form-select form-select-sm" style="width:auto">
            <option value="10">10</option><option value="20">20</option><option value="50">50</option>
          </select>
        </div>
      </div>

      <div class="table-responsive">
        <table class="table table-hover table-striped table-bordered align-middle" id="tblProduk">
          <thead class="table-light">
            <tr>
              <th>Gambar</th>
              <th>Nama</th>
              <th>Kategori</th>
              <th>Harga</th>
              <th>Stok</th>
              <th style="width:140px" class="text-center">Aksi</th>
            </tr>
          </thead>
          <tbody><!-- JS --></tbody>
        </table>
      </div>
      <div class="d-flex justify-content-between align-items-center">
        <small class="text-muted" id="metaProduk"></small>
        <div class="btn-group">
          <button class="btn btn-sm btn-outline-secondary" id="prevProduk">«</button>
          <button class="btn btn-sm btn-outline-secondary" id="nextProduk">»</button>
        </div>
      </div>
    </div>
  </div>

  <!-- ================== TABEL TRANSAKSI ================== -->
  <div class="col-12">
    <div class="box p-3 p-md-4">
      <div class="d-flex justify-content-between align-items-center mb-3">
        <h2 class="h5 fw-bold m-0"><i class="fa-solid fa-receipt me-2"></i>Riwayat Transaksi</h2>
        <div class="d-flex gap-2">
          <select id="filterProduk" class="form-select form-select-sm" style="min-width:220px">
            <option value="">Semua produk</option>
          </select>
          <button class="btn btn-sm btn-success" data-bs-toggle="modal" data-bs-target="#modalAddTrx">
            <i class="fa-solid fa-plus me-1"></i> Transaksi
          </button>
        </div>
      </div>

      <div class="table-responsive">
        <table class="table table-hover table-striped table-bordered align-middle" id="tblTrx">
          <thead class="table-light">
            <tr>
              <th>Waktu</th>
              <th>Produk</th>
              <th>Tipe</th>
              <th class="text-end">Qty</th>
              <th class="text-end">Harga</th>
              <th class="text-end">Total</th>
              <th>Customer</th>
              <th>Catatan</th>
              <th style="width:120px" class="text-center">Aksi</th>
            </tr>
          </thead>
          <tbody><!-- JS --></tbody>
        </table>
      </div>
      <div class="d-flex justify-content-between align-items-center">
        <small class="text-muted" id="metaTrx"></small>
        <div class="btn-group">
          <button class="btn btn-sm btn-outline-secondary" id="prevTrx">«</button>
          <button class="btn btn-sm btn-outline-secondary" id="nextTrx">»</button>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- ===== Modal Edit Stok ===== -->
<div class="modal fade" id="modalStok" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog">
    <form class="modal-content" id="formStok">
      <div class="modal-header">
        <h5 class="modal-title"><i class="fa-solid fa-boxes-stacked me-2"></i>Edit Stok</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <input type="hidden" name="produk_id" id="stokProdukId">
        <div class="mb-2">
          <label class="form-label">Nama Produk</label>
          <input type="text" id="stokNama" class="form-control" disabled>
        </div>
        <div class="mb-2">
          <label class="form-label">Perubahan Stok (±)</label>
          <input type="number" class="form-control" name="delta" placeholder="contoh: 5 atau -3" required>
          <small class="text-muted">Positif menambah, negatif mengurangi.</small>
        </div>
      </div>
      <div class="modal-footer">
        <button class="btn btn-primary" type="submit">
          <i class="fa-solid fa-floppy-disk me-1"></i>Simpan
        </button>
      </div>
    </form>
  </div>
</div>

<!-- ===== Modal Tambah Transaksi ===== -->
<div class="modal fade" id="modalAddTrx" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog">
    <form class="modal-content" id="formAddTrx">
      <div class="modal-header">
        <h5 class="modal-title"><i class="fa-solid fa-plus me-2"></i>Catat Transaksi</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <div class="mb-2">
          <label class="form-label">Produk</label>
          <select class="form-select" name="produk_id" id="trxProdukPage" data-role="produk-select" required>
            <option value="">-- Pilih --</option>
          </select>
        </div>
        <div class="mb-2">
          <label class="form-label">Tipe</label>
          <select class="form-select" name="tipe" required>
            <option value="keluar">Keluar (Penjualan)</option>
            <option value="masuk">Masuk (Restock)</option>
          </select>
        </div>
        <div class="mb-2">
          <label class="form-label">Qty</label>
          <input type="number" class="form-control" name="qty" min="1" required>
        </div>
        <div class="mb-2">
          <label class="form-label">Customer (opsional)</label>
          <input type="text" class="form-control" name="customer">
        </div>
        <div class="mb-2">
          <label class="form-label">Catatan</label>
          <textarea class="form-control" name="catatan" rows="3"></textarea>
        </div>
        <small class="text-muted">Harga diambil dari harga produk saat ini (otomatis).</small>
      </div>
      <div class="modal-footer">
        <button class="btn btn-success" type="submit">
          <i class="fa-solid fa-plus me-1"></i>Catat
        </button>
      </div>
    </form>
  </div>
</div>

<!-- ===== Modal Edit Transaksi (customer/catatan) ===== -->
<div class="modal fade" id="modalEditTrx" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog">
    <form class="modal-content" id="formEditTrx">
      <div class="modal-header">
        <h5 class="modal-title"><i class="fa-solid fa-pen-to-square me-2"></i>Edit Transaksi</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <input type="hidden" name="id" id="editTrxId">
        <div class="mb-2">
          <label class="form-label">Customer</label>
          <input type="text" class="form-control" name="customer" id="editCustomer">
        </div>
        <div class="mb-2">
          <label class="form-label">Catatan</label>
          <textarea class="form-control" name="catatan" id="editCatatan" rows="3"></textarea>
        </div>
        <small class="text-muted">Tipe/qty tidak diubah di sini agar stok historis tetap konsisten.</small>
      </div>
      <div class="modal-footer">
        <button class="btn btn-primary" type="submit">
          <i class="fa-solid fa-floppy-disk me-1"></i>Simpan
        </button>
      </div>
    </form>
  </div>
</div>

<!-- Toast -->
<div class="toast-container" id="toastContainer" style="position:fixed;right:14px;bottom:14px;z-index:2000;"></div>

<script>
const CSRF = '<?= e($csrf_token) ?>';
const rupiah = n => 'Rp ' + (Number(n||0)).toLocaleString('id-ID');

function toast(msg, ok=true){
  const box=document.getElementById('toastContainer');
  const el=document.createElement('div');
  el.className='toast align-items-center text-bg-'+(ok?'success':'danger')+' border-0 show';
  el.innerHTML=`<div class="d-flex"><div class="toast-body">${msg}</div>
    <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"></button></div>`;
  box.appendChild(el); setTimeout(()=>el.remove(),3500);
}

async function api(action, payload={}){
  const fd = new FormData();
  fd.append('action', action);
  fd.append('csrf', CSRF);
  Object.entries(payload).forEach(([k,v])=>fd.append(k,v));
  const r = await fetch('inventory_api.php',{method:'POST',body:fd,headers:{'X-Requested-With':'XMLHttpRequest'}});
  const j = await r.json().catch(()=>({ok:false,message:'Respon tidak valid'}));
  if(!j.ok) throw new Error(j.message||'Error'); return j;
}
function formToObj(form){
  const o={}; (new FormData(form)).forEach((v,k)=>{ if(k!=='action'&&k!=='csrf') o[k]=v; }); return o;
}

/* ---------- Re-populate opsi produk (modal & filter) ---------- */
async function refreshProdukLists(){
  const out = await api('list_produk', { page: 1, per_page: 1000 });
  const optionsHTML =
    '<option value="">-- Pilih --</option>' +
    out.data.map(p => `<option value="${p.id}">${p.nama_produk} (Stok: ${p.stok})</option>`).join('');

  // Semua dropdown yang ditandai data-role="produk-select"
  document.querySelectorAll('[data-role="produk-select"]').forEach(sel => {
    const current = sel.value;
    sel.innerHTML = optionsHTML;
    if (current) sel.value = current;
  });

  // Filter di tabel transaksi
  const filt = document.getElementById('filterProduk');
  if (filt){
    const cur = filt.value;
    filt.innerHTML = '<option value="">Semua produk</option>' +
      out.data.map(p => `<option value="${p.id}">${p.nama_produk}</option>`).join('');
    if (cur) filt.value = cur;
  }
}

/* ---------- Produk table ---------- */
let pPage=1, pPer=10, pQ='';
const tblProduk=document.querySelector('#tblProduk tbody');
const metaProduk=document.getElementById('metaProduk');

async function loadProduk(){
  const out=await api('list_produk',{page:pPage,per_page:pPer,q:pQ});
  tblProduk.innerHTML='';
  out.data.forEach(row=>{
    const tr=document.createElement('tr');
    const img=row.gambar?('../uploads/'+row.gambar):'../assets/placeholder.png';
    tr.innerHTML=`
      <td><img src="${img}" class="thumb" alt=""></td>
      <td><div class="fw-bold">${row.nama_produk}</div></td>
      <td><span class="badge bg-warning-subtle text-dark badge-pill">${row.nama_kategori||'-'}</span></td>
      <td class="text-end">${rupiah(row.harga)}</td>
      <td class="fw-bold">${row.stok}</td>
      <td class="text-center">
        <button class="btn btn-sm btn-primary btn-stok" data-id="${row.id}" data-nama="${row.nama_produk}">
          <i class="fa-solid fa-pen-to-square"></i> Edit Stok
        </button>
      </td>`;
    tblProduk.appendChild(tr);
  });
  const from=(out.total?((pPage-1)*pPer+1):0), to=Math.min(pPage*pPer,out.total);
  metaProduk.textContent=`Menampilkan ${from}-${to} dari ${out.total} produk`;
  document.getElementById('prevProduk').disabled = pPage<=1;
  document.getElementById('nextProduk').disabled = pPage*out.per_page >= out.total;
}
document.getElementById('qProduk').addEventListener('input', e=>{ pQ=e.target.value.trim(); pPage=1; loadProduk(); });
document.getElementById('perProduk').addEventListener('change', e=>{ pPer=parseInt(e.target.value||10); pPage=1; loadProduk(); });
document.getElementById('prevProduk').addEventListener('click', ()=>{ if(pPage>1){ pPage--; loadProduk(); }});
document.getElementById('nextProduk').addEventListener('click', ()=>{ pPage++; loadProduk(); });
tblProduk.addEventListener('click', e=>{
  const btn=e.target.closest('.btn-stok'); if(!btn) return;
  document.getElementById('stokProdukId').value=btn.dataset.id;
  document.getElementById('stokNama').value=btn.dataset.nama;
  new bootstrap.Modal('#modalStok').show();
});

/* ---------- Transaksi table ---------- */
let tPage=1, tPer=10, tFilter='';
const tblTrx=document.querySelector('#tblTrx tbody');
const metaTrx=document.getElementById('metaTrx');

async function loadTrx(){
  const out=await api('list_transaksi',{page:tPage,per_page:tPer,produk_id:tFilter||''});
  tblTrx.innerHTML='';
  out.data.forEach(r=>{
    const tipeBadge = r.tipe==='keluar'
      ? '<span class="badge bg-danger-subtle text-danger badge-pill">keluar</span>'
      : '<span class="badge bg-success-subtle text-success badge-pill">masuk</span>';
    const tr=document.createElement('tr');
    tr.innerHTML=`
      <td>${r.created_at}</td>
      <td>${r.nama_produk}</td>
      <td>${tipeBadge}</td>
      <td class="text-end">${r.qty}</td>
      <td class="text-end">${rupiah(r.harga_saat_transaksi)}</td>
      <td class="text-end">${rupiah(r.total)}</td>
      <td>${r.customer||'-'}</td>
      <td>${r.catatan||'-'}</td>
      <td class="text-center">
        <button class="btn btn-sm btn-primary btn-edit-trx" data-id="${r.id}" data-customer="${r.customer||''}" data-catatan="${r.catatan||''}">
          <i class="fa-solid fa-pen-to-square"></i>
        </button>
        <button class="btn btn-sm btn-danger btn-del-trx" data-id="${r.id}">
          <i class="fa-solid fa-trash"></i>
        </button>
      </td>`;
    tblTrx.appendChild(tr);
  });
  const from=(out.total?((tPage-1)*tPer+1):0), to=Math.min(tPage*tPer,out.total);
  metaTrx.textContent=`Menampilkan ${from}-${to} dari ${out.total} transaksi`;
  document.getElementById('prevTrx').disabled = tPage<=1;
  document.getElementById('nextTrx').disabled = tPage*out.per_page >= out.total;
}
document.getElementById('filterProduk').addEventListener('change', e=>{ tFilter=e.target.value; tPage=1; loadTrx(); });
document.getElementById('prevTrx').addEventListener('click', ()=>{ if(tPage>1){ tPage--; loadTrx(); }});
document.getElementById('nextTrx').addEventListener('click', ()=>{ tPage++; loadTrx(); });

tblTrx.addEventListener('click', async e=>{
  const edit=e.target.closest('.btn-edit-trx'); const del=e.target.closest('.btn-del-trx');
  if (edit){
    document.getElementById('editTrxId').value=edit.dataset.id;
    document.getElementById('editCustomer').value=edit.dataset.customer||'';
    document.getElementById('editCatatan').value=edit.dataset.catatan||'';
    new bootstrap.Modal('#modalEditTrx').show();
  }
  if (del){
    if(confirm('Hapus transaksi ini? (stok historis tidak diubah)')){
      try{ await api('delete_transaksi',{id:del.dataset.id}); toast('Transaksi dihapus'); loadTrx(); }
      catch(err){ toast(err.message,false); }
    }
  }
});

/* ---------- Submit forms ---------- */
document.getElementById('formStok').addEventListener('submit', async e=>{
  e.preventDefault();
  const btn=e.target.querySelector('button[type="submit"]');
  btn.disabled=true; btn.innerHTML='<span class="spinner-border spinner-border-sm me-1"></span>Simpan';
  try{
    const out=await api('update_stok', formToObj(e.target));
    toast(out.message);
    bootstrap.Modal.getInstance('#modalStok').hide();
    e.target.reset();
    await loadProduk();
    await refreshProdukLists(); // penting: sinkron dropdown
  }catch(err){ toast(err.message,false); }
  finally{ btn.disabled=false; btn.innerHTML='<i class="fa-solid fa-floppy-disk me-1"></i>Simpan'; }
});

document.getElementById('formAddTrx').addEventListener('submit', async e=>{
  e.preventDefault();
  const btn=e.target.querySelector('button[type="submit"]');
  btn.disabled=true; btn.innerHTML='<span class="spinner-border spinner-border-sm me-1"></span>Simpan';
  try{
    const out=await api('add_transaksi', formToObj(e.target));
    toast(out.message);
    bootstrap.Modal.getInstance('#modalAddTrx').hide();
    e.target.reset();
    await loadProduk();
    await loadTrx();
    await refreshProdukLists(); // penting: sinkron dropdown
  }catch(err){ toast(err.message,false); }
  finally{ btn.disabled=false; btn.innerHTML='<i class="fa-solid fa-plus me-1"></i>Catat'; }
});

document.getElementById('formEditTrx').addEventListener('submit', async e=>{
  e.preventDefault();
  const btn=e.target.querySelector('button[type="submit"]');
  btn.disabled=true; btn.innerHTML='<span class="spinner-border spinner-border-sm me-1"></span>Simpan';
  try{
    const out=await api('update_transaksi', formToObj(e.target));
    toast(out.message);
    bootstrap.Modal.getInstance('#modalEditTrx').hide();
    await loadTrx();
  }catch(err){ toast(err.message,false); }
  finally{ btn.disabled=false; btn.innerHTML='<i class="fa-solid fa-floppy-disk me-1"></i>Simpan'; }
});

/* Refresh dropdown saat modal transaksi dibuka */
const addModalEl = document.getElementById('modalAddTrx');
if (addModalEl) addModalEl.addEventListener('show.bs.modal', () => { refreshProdukLists(); });

/* Init */
loadProduk();
loadTrx();
refreshProdukLists();
</script>

<?php require_once __DIR__ . '/../includes/footer_admin.php'; ?>
