<?php
// admin/profil.php (FIX: proses POST sebelum output)
if (session_status() === PHP_SESSION_NONE) session_start();
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__.'/../includes/db.php';
require_once __DIR__.'/auth.php'; // langsung auth di sini agar bisa redirect sebelum output

if (!function_exists('e')) { function e($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); } }

function upload_img($file){
  if (($file['error'] ?? UPLOAD_ERR_NO_FILE) !== UPLOAD_ERR_OK) return null;
  $ext = strtolower(pathinfo($file['name'] ?? '', PATHINFO_EXTENSION));
  if (!in_array($ext, ['jpg','jpeg','png','webp','gif'])) return null;
  $dir = __DIR__.'/../uploads/';
  if (!is_dir($dir)) @mkdir($dir,0775,true);
  $name = 'profil_'.uniqid().'.'.$ext;
  if (move_uploaded_file($file['tmp_name'], $dir.$name)) return $name;
  return null;
}

/* ===================== PROSES SIMPAN (HARUS DI ATAS) ===================== */
if ($_SERVER['REQUEST_METHOD']==='POST'){
  $judul   = trim($_POST['judul'] ?? '');
  $alamat  = trim($_POST['alamat'] ?? '');
  $telepon = trim($_POST['telepon'] ?? '');
  $jam     = trim($_POST['jam_buka'] ?? '');

  // sanitasi deskripsi: allow tag sederhana
  $allowed = '<p><br><b><strong><i><em><u><ol><ul><li><h1><h2><h3><h4><h5><h6><blockquote><a>';
  $desk    = strip_tags($_POST['deskripsi'] ?? '', $allowed);

  // ambil yang lama
  $row = $conn->query("SELECT * FROM profil_warung WHERE id=1")->fetch_assoc() ?: [];

  $updates = [
    'judul'     => $judul,
    'deskripsi' => $desk,
    'alamat'    => $alamat,
    'telepon'   => $telepon,
    'jam_buka'  => $jam
  ];

  // handle 6 gambar
  for ($i=1; $i<=6; $i++){
    if (!empty($_FILES["foto$i"]['name'])) {
      $up = upload_img($_FILES["foto$i"]);
      if ($up){
        if (!empty($row["foto$i"]) && file_exists(__DIR__."/../uploads/".$row["foto$i"])) @unlink(__DIR__."/../uploads/".$row["foto$i"]);
        $updates["foto$i"] = $up;
      }
    } elseif (!empty($_POST["hapus_foto$i"])) {
      if (!empty($row["foto$i"]) && file_exists(__DIR__."/../uploads/".$row["foto$i"])) @unlink(__DIR__."/../uploads/".$row["foto$i"]);
      $updates["foto$i"] = NULL; // biarkan NULL
    }
  }

  // insert atau update
  $exists = $conn->query("SELECT 1 FROM profil_warung WHERE id=1")->num_rows>0;
  if ($exists){
    // bangun SET dinamis, handle NULL tanpa placeholder
    $setParts = []; $vals = []; $types = '';
    foreach($updates as $k=>$v){
      if ($v === NULL){
        $setParts[] = "$k = NULL";
      } else {
        $setParts[] = "$k = ?";
        $vals[]  = $v;
        $types  .= 's';
      }
    }
    $sql  = "UPDATE profil_warung SET ".implode(', ', $setParts)." WHERE id=1";
    $stmt = $conn->prepare($sql);
    if ($types !== ''){
      $stmt->bind_param($types, ...$vals);
    }
    $ok = $stmt->execute();
  } else {
    // kolom & placeholder hanya untuk nilai non-NULL
    $cols = ['id']; $place = ['1']; $vals = []; $types = '';
    foreach($updates as $k=>$v){
      $cols[] = $k;
      if ($v === NULL){
        $place[] = 'NULL';
      } else {
        $place[] = '?';
        $vals[]  = $v;
        $types  .= 's';
      }
    }
    $sql  = "INSERT INTO profil_warung (".implode(',', $cols).") VALUES (".implode(',', $place).")";
    $stmt = $conn->prepare($sql);
    if ($types !== ''){
      $stmt->bind_param($types, ...$vals);
    }
    $ok = $stmt->execute();
  }

  $_SESSION['notice'] = $ok ? 'Profil berhasil disimpan.' : 'Gagal menyimpan profil.';
  header('Location: profil.php'); // aman, belum ada output
  exit();
}
/* ===================== /PROSES SIMPAN ===================== */

// data untuk tampilan
$pf = $conn->query("SELECT * FROM profil_warung WHERE id=1")->fetch_assoc() ?: [
  'judul'=>'Tentang Kedai Kami','deskripsi'=>'','alamat'=>'','telepon'=>'','jam_buka'=>''
];

/* Setelah semua logika selesai, barulah include header (mulai output) */
$page_title = 'Profil Kedai';
$breadcrumb = 'Admin / Profil';
require_once __DIR__.'/../includes/header_admin.php';
?>

<!-- ==== STYLE untuk preview gambar standar ==== -->
<style>
  .card-box{
    background:#fff;border:1px solid rgba(0,0,0,.06);border-radius:18px;
    box-shadow:0 10px 30px rgba(0,0,0,.06);overflow:hidden;margin-bottom:24px;
  }
  .card-header{padding:16px 20px;border-bottom:1px solid rgba(0,0,0,.06)}
  .card-title{margin:0;font-weight:700}
  .form-grid{padding:20px}
  .form-row{display:flex;flex-direction:column;gap:8px;margin-bottom:14px}
  .input, .textarea, .btn-primary, .btn-ghost{border-radius:12px}
  .input, .textarea{border:1px solid #e5e7eb;padding:10px 12px}
  .textarea{min-height:140px}
  .actions{display:flex;gap:10px;align-items:center;margin-top:6px}
  .btn-primary{background:#ff7b54;border:0;color:#fff;font-weight:700;padding:10px 14px}
  .btn-ghost{border:2px solid #e5e7eb;background:#fff;color:#111827;padding:9px 14px}
  .notice.success{
    margin:16px 20px 0;background:#ecfdf5;border:1px solid #a7f3d0;color:#065f46;
    padding:10px 12px;border-radius:12px;font-weight:600
  }
  /* Preview gambar standar (seragam, tidak kebesaran) */
  .table-preview{
    width:150px;height:110px;object-fit:cover;border-radius:10px;
    border:2px solid rgba(0,0,0,.08);background:#f8fafc;display:block;
  }
  .current-image{
    display:flex;align-items:center;gap:12px;
    background:linear-gradient(135deg,#111827,#0b1324);
    color:#fff;border-radius:14px;padding:10px 12px
  }
  .form-grid input[type="file"]{
    padding:8px 10px;border:1px dashed #d1d5db;background:#fafafa;border-radius:10px
  }
  .galeri-grid{display:grid;grid-template-columns:repeat(auto-fill,minmax(220px,1fr));gap:14px}
</style>

<div class="card-box">
  <div class="card-header"><h2 class="card-title">✏️ Edit Profil Kedai</h2></div>

  <?php if(!empty($_SESSION['notice'])): ?>
    <div class="notice success">✅ <?= e($_SESSION['notice']); unset($_SESSION['notice']); ?></div>
  <?php endif; ?>

  <form action="profil.php" method="post" enctype="multipart/form-data" class="form-grid">
    <div class="form-row">
      <label for="judul">Judul</label>
      <input class="input" id="judul" name="judul" type="text" value="<?= e($pf['judul']) ?>" required>
    </div>

    <div class="form-row">
      <label for="deskripsi">Deskripsi (boleh HTML sederhana)</label>
      <textarea class="textarea" id="deskripsi" name="deskripsi" rows="10" placeholder="Ceritakan tentang Kedai Anda…"><?= e($pf['deskripsi']) ?></textarea>
    </div>

    <div class="form-row">
      <label for="alamat">Alamat</label>
      <input class="input" id="alamat" name="alamat" type="text" value="<?= e($pf['alamat']) ?>">
    </div>

    <div class="form-row">
      <label for="telepon">Telepon/WA</label>
      <input class="input" id="telepon" name="telepon" type="text" value="<?= e($pf['telepon']) ?>">
    </div>

    <div class="form-row">
      <label for="jam_buka">Jam Buka</label>
      <input class="input" id="jam_buka" name="jam_buka" type="text" value="<?= e($pf['jam_buka']) ?>" placeholder="Contoh: 08:00 - 21:00 (Setiap Hari)">
    </div>

    <div class="form-row">
      <label>Galeri Foto (maks 6)</label>
      <div class="galeri-grid">
        <?php for($i=1;$i<=6;$i++): ?>
          <div>
            <div class="current-image">
              <?php if(!empty($pf["foto$i"])): ?>
                <img src="../uploads/<?= e($pf["foto$i"]) ?>" class="table-preview" alt="Foto <?= $i ?>">
                <div>
                  <div><strong>Foto <?= $i ?></strong></div>
                  <div style="font-size:12px;color:rgba(255,255,255,.8)">Ganti / hapus jika perlu</div>
                </div>
              <?php else: ?>
                <img src="data:image/svg+xml,<?= urlencode('<svg xmlns=\'http://www.w3.org/2000/svg\' width=\'150\' height=\'110\'><rect width=\'100%\' height=\'100%\' fill=\'#f1f5f9\'/></svg>') ?>" class="table-preview" alt="Placeholder <?= $i ?>">
                <div>
                  <div><strong>Foto <?= $i ?></strong></div>
                  <div style="font-size:12px;color:rgba(255,255,255,.6)">Belum ada</div>
                </div>
              <?php endif; ?>
            </div>

            <div style="margin-top:8px;display:flex;align-items:center;gap:8px;flex-wrap:wrap">
              <input class="input" type="file" name="foto<?= $i ?>" accept="image/*" style="flex:1 1 auto">
              <?php if(!empty($pf["foto$i"])): ?>
                <label style="margin:0;user-select:none">
                  <input type="checkbox" name="hapus_foto<?= $i ?>" value="1"> Hapus
                </label>
              <?php endif; ?>
            </div>
          </div>
        <?php endfor; ?>
      </div>
    </div>

    <div class="actions">
      <button class="btn-primary" type="submit">💾 Simpan Profil</button>
      <a class="btn-ghost" href="../profil.php" target="_blank">👁️ Lihat Halaman</a>
    </div>
  </form>
</div>

<?php require_once __DIR__.'/../includes/footer_admin.php'; ?>
