<?php
// ====== PROSES AKSI (WAJIB DI ATAS, sebelum output HTML) ======
if (session_status() === PHP_SESSION_NONE) session_start();
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/auth.php'; // pastikan path sesuai

// helper escape (kalau belum ada)
if (!function_exists('e')) {
  function e($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
}

// --- Upload gambar helper ---
function upload_gambar($file){
  $dir = __DIR__ . '/../uploads/';
  if (!is_dir($dir)) @mkdir($dir, 0775, true);

  $nama = uniqid() . '_' . preg_replace('/\s+/', '_', basename($file['name']));
  $target = $dir . $nama;
  $ext = strtolower(pathinfo($target, PATHINFO_EXTENSION));

  if (!in_array($ext, ['jpg','jpeg','png','gif','webp'])) {
    $_SESSION['error'] = 'Tipe file harus JPG, JPEG, PNG, GIF, atau WEBP.';
    return false;
  }
  $check = @getimagesize($file['tmp_name']);
  if ($check === false) {
    $_SESSION['error'] = 'File bukan gambar valid.';
    return false;
  }
  if (move_uploaded_file($file['tmp_name'], $target)) return $nama;

  $_SESSION['error'] = 'Gagal upload gambar.';
  return false;
}

// --- Tambah / Update ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit_produk'])) {
  $id          = (int)($_POST['id'] ?? 0);
  $kategori_id = (int)($_POST['kategori_id'] ?? 0);
  $nama_produk = trim($_POST['nama_produk'] ?? '');
  $deskripsi   = trim($_POST['deskripsi'] ?? '');
  $harga       = (int)($_POST['harga'] ?? 0);
  $gambar_lama = $_POST['gambar_lama'] ?? '';
  $gambar_baru = $gambar_lama;

  if (isset($_FILES['gambar']) && $_FILES['gambar']['error'] === 0) {
    $up = upload_gambar($_FILES['gambar']);
    if ($up) {
      $gambar_baru = $up;
      if ($gambar_lama && file_exists(__DIR__ . "/../uploads/" . $gambar_lama)) {
        @unlink(__DIR__ . "/../uploads/" . $gambar_lama);
      }
    } else {
      header("Location: produk.php"); exit();
    }
  }

  if ($id === 0) {
    $stmt = $conn->prepare("INSERT INTO produk (kategori_id, nama_produk, deskripsi, harga, gambar) VALUES (?, ?, ?, ?, ?)");
    if (!$stmt) { $_SESSION['error'] = 'DB error: '.$conn->error; header("Location: produk.php"); exit(); }
    $stmt->bind_param("issis", $kategori_id, $nama_produk, $deskripsi, $harga, $gambar_baru);
    $_SESSION['notice'] = $stmt->execute() ? 'Produk berhasil ditambahkan.' : ('Gagal tambah produk: '.$stmt->error);
  } else {
    $stmt = $conn->prepare("UPDATE produk SET kategori_id=?, nama_produk=?, deskripsi=?, harga=?, gambar=? WHERE id=?");
    if (!$stmt) { $_SESSION['error'] = 'DB error: '.$conn->error; header("Location: produk.php"); exit(); }
    $stmt->bind_param("issisi", $kategori_id, $nama_produk, $deskripsi, $harga, $gambar_baru, $id);
    $_SESSION['notice'] = $stmt->execute() ? 'Produk berhasil diperbarui.' : ('Gagal update produk: '.$stmt->error);
  }

  header("Location: produk.php"); exit();
}

// --- Hapus ---
if (isset($_GET['action'], $_GET['id']) && $_GET['action'] === 'delete') {
  $id = (int)$_GET['id'];

  $stm = $conn->prepare("SELECT gambar FROM produk WHERE id=?");
  if ($stm) { $stm->bind_param("i", $id); $stm->execute(); $g = $stm->get_result()->fetch_assoc(); }
  if (!empty($g['gambar']) && file_exists(__DIR__ . "/../uploads/" . $g['gambar'])) {
    @unlink(__DIR__ . "/../uploads/" . $g['gambar']);
  }

  $d = $conn->prepare("DELETE FROM produk WHERE id=?");
  if ($d) {
    $d->bind_param("i", $id);
    $_SESSION['notice'] = $d->execute() ? 'Produk berhasil dihapus.' : ('Gagal hapus produk: '.$d->error);
  } else {
    $_SESSION['error'] = 'DB error: '.$conn->error;
  }

  header("Location: produk.php"); exit();
}

// ====== Setelah proses aksi, baru include header admin (layout + sidebar) ======
$page_title = 'Kelola Produk';
$breadcrumb = 'Admin / Produk';
require_once __DIR__ . '/../includes/header_admin.php';

// ====== Variabel halaman & pagination ======
$action   = $_GET['action'] ?? 'list';
$per_page = 6; // tetap 6 per halaman
$page     = isset($_GET['page']) ? max(1, (int)$_GET['page']) : 1;
$offset   = ($page - 1) * $per_page;

// helper: base url tanpa parameter page (untuk link pagination)
function build_base_url_without($param='page'){
  $qs = $_GET; unset($qs[$param]);
  $base = basename($_SERVER['PHP_SELF']);
  return $base.(count($qs)?('?'.http_build_query($qs)):'');
}
$base_url = build_base_url_without('page');
?>

<style>
  /* ========= OVERRIDE: buat halaman benar-benar full width ========= */
  .container,
  .container-sm, .container-md, .container-lg, .container-xl, .container-xxl,
  .content, .content-wrapper, .main-content, .page-content, .app-content, .app-main, .wrapper {
    max-width: 100% !important;
    width: 100% !important;
  }
  .container-fluid {
    max-width: 100% !important;
    padding-left: 24px !important;
    padding-right: 24px !important;
  }
  .content, .content-wrapper, .main-content, .page-content, .app-content, .wrapper {
    margin-left: 0 !important;
    margin-right: 0 !important;
  }
  .box { width: 100%; }

  /* ========= Tema aurora + brand oranye ========= */
  :root{
    --bg-base-0:#f7f8ff; --bg-base-1:#efeafd; --bg-base-2:#ffece3;
    --bg-accent-1:#c7e7ff; --bg-accent-2:#ffd6e5; --bg-accent-3:#dff7e4;
    --brand-1:#ff7b54; --brand-2:#ff9068;
    --card-bg:rgba(255,255,255,.9); --card-border:rgba(255,255,255,.6);
  }
  body{
    background:
      radial-gradient(65rem 40rem at 10% -10%, var(--bg-accent-1) 0%, transparent 55%),
      radial-gradient(55rem 35rem at 90% 0%,  var(--bg-accent-2) 0%, transparent 52%),
      radial-gradient(70rem 45rem at 50% 110%, var(--bg-accent-3) 0%, transparent 50%),
      linear-gradient(180deg, var(--bg-base-0) 0%, var(--bg-base-1) 45%, var(--bg-base-2) 100%);
    min-height:100vh;
  }
  .box{
    background: var(--card-bg); border:1px solid var(--card-border);
    border-radius:22px; box-shadow: 0 24px 60px rgba(21,23,42,.10);
  }
  .box-topbar{ position:relative; overflow:hidden }
  .box-topbar::before{
    content:""; position:absolute; left:14px; right:14px; top:0; height:6px; border-radius:0 0 8px 8px;
    background: linear-gradient(90deg, var(--brand-1), var(--brand-2));
  }
  .btn-brand{
    color:#fff; border:0; border-radius:14px; font-weight:700;
    background: linear-gradient(135deg, var(--brand-1), var(--brand-2));
    box-shadow: 0 12px 26px rgba(255,123,84,.35);
  }
  .btn-ghost{
    border:2px solid rgba(17,24,39,.08); border-radius:14px; font-weight:700;
    background:#fff; color:#111827;
  }
  .badge-kat{
    background: linear-gradient(135deg, var(--brand-1), var(--brand-2));
    box-shadow: 0 6px 18px rgba(255,123,84,.35);
  }

  /* Thumbnail di tabel (biarkan kecil) */
  .table img.thumb{
    width:70px; height:70px; object-fit:cover; border-radius:12px;
    border:2px solid rgba(17,24,39,.08);
  }

  .price-cell{ font-weight:900; color:#0f766e }

  /* Biar tabel nyaman di layar super lebar */
  .table-responsive { overflow-x: auto; }
  .table { width: 100%; table-layout: auto; }

  /* ========= Tambahan: preview gambar di FORM edit/tambah ========= */
  .form-preview{
    width: 150px;         /* ukuran standar preview */
    height: 110px;
    object-fit: cover;    /* rapi, ter-crop halus */
    border-radius: 12px;
    border: 2px solid rgba(17,24,39,.08);
    background: #fff;
    display: block;
  }
</style>

<div class="container-fluid py-3">
  <!-- Header card -->
  <div class="box box-topbar p-4 mb-4">
    <div class="d-flex flex-column flex-md-row justify-content-between align-items-md-center gap-2">
      <div>
        <h1 class="h4 fw-bold m-0">🏪 Kelola Produk</h1>
        <div class="text-muted"><?= e($breadcrumb) ?></div>
      </div>
      <div>
        <?php if($action === 'list'): ?>
          <a href="produk.php?action=add" class="btn btn-brand px-3">
            <i class="fa-solid fa-plus me-2"></i>Tambah Produk Baru
          </a>
        <?php else: ?>
          <a href="produk.php" class="btn btn-ghost px-3">
            <i class="fa-solid fa-arrow-left me-2"></i>Kembali
          </a>
        <?php endif; ?>
      </div>
    </div>
  </div>

  <!-- Notifikasi -->
  <?php if(isset($_SESSION['notice'])){ ?>
    <div class="alert alert-success box fw-semibold"><?= '✅ '.e($_SESSION['notice']); ?></div>
  <?php unset($_SESSION['notice']); } ?>
  <?php if(isset($_SESSION['error'])){ ?>
    <div class="alert alert-danger box fw-semibold"><?= '❌ '.e($_SESSION['error']); ?></div>
  <?php unset($_SESSION['error']); } ?>

  <?php
    if ($action === 'add' || ($action === 'edit' && isset($_GET['id']))):
      $p = ['id'=>'', 'kategori_id'=>'', 'nama_produk'=>'', 'deskripsi'=>'', 'harga'=>'', 'gambar'=>''];
      $title = 'Tambah Produk Baru'; $icon = 'fa-plus';
      if ($action === 'edit') {
        $title = 'Edit Produk'; $icon = 'fa-pen-to-square';
        $id = (int)$_GET['id'];
        $st = $conn->prepare("SELECT * FROM produk WHERE id=?");
        $st->bind_param("i", $id); $st->execute();
        $r = $st->get_result();
        if ($r->num_rows > 0) $p = $r->fetch_assoc();
      }
      $kategori_res = $conn->query("SELECT * FROM kategori ORDER BY nama_kategori");
  ?>
    <!-- Form -->
    <div class="box box-topbar p-4 p-md-5 mb-4">
      <h2 class="h5 fw-bold mb-4"><i class="fa-solid <?= $icon ?> me-2"></i><?= e($title) ?></h2>

      <form action="produk.php" method="POST" class="row g-3" enctype="multipart/form-data">
        <input type="hidden" name="id" value="<?= e($p['id']) ?>">
        <input type="hidden" name="gambar_lama" value="<?= e($p['gambar']) ?>">

        <div class="col-12">
          <label for="nama_produk" class="form-label fw-bold text-uppercase small">Nama Produk</label>
          <input id="nama_produk" name="nama_produk" type="text" class="form-control" value="<?= e($p['nama_produk']) ?>" required>
        </div>

        <div class="col-md-6">
          <label for="kategori_id" class="form-label fw-bold text-uppercase small">Kategori</label>
          <select id="kategori_id" name="kategori_id" class="form-select" required>
            <option value="">-- Pilih Kategori --</option>
            <?php while($k = $kategori_res->fetch_assoc()):
              $sel = ($k['id'] == $p['kategori_id']) ? 'selected' : ''; ?>
              <option value="<?= (int)$k['id'] ?>" <?= $sel ?>><?= e($k['nama_kategori']) ?></option>
            <?php endwhile; ?>
          </select>
        </div>

        <div class="col-md-6">
          <label for="harga" class="form-label fw-bold text-uppercase small">Harga (Rp)</label>
          <input id="harga" name="harga" type="number" min="0" class="form-control" value="<?= e($p['harga']) ?>" required>
        </div>

        <div class="col-12">
          <label for="deskripsi" class="form-label fw-bold text-uppercase small">Deskripsi</label>
          <textarea id="deskripsi" name="deskripsi" rows="5" class="form-control"><?= e($p['deskripsi']) ?></textarea>
        </div>

        <div class="col-12">
          <label for="gambar" class="form-label fw-bold text-uppercase small">Gambar Produk</label>
          <input id="gambar" name="gambar" type="file" accept="image/*" class="form-control">
          <?php if(!empty($p['gambar'])): ?>
            <div class="d-flex align-items-center gap-3 mt-3 p-3 rounded-3 border bg-white">
              <!-- GANTI class dari 'thumb' ke 'form-preview' -->
              <img src="../uploads/<?= e($p['gambar']) ?>" alt="Preview" class="form-preview">
              <div class="text-muted small">Gambar saat ini</div>
            </div>
          <?php endif; ?>
        </div>

        <div class="col-12 d-flex gap-2">
          <button class="btn btn-brand px-3" type="submit" name="submit_produk">
            <i class="fa-solid fa-floppy-disk me-2"></i> Simpan Produk
          </button>
          <a class="btn btn-ghost px-3" href="produk.php">
            <i class="fa-solid fa-arrow-left me-2"></i> Kembali
          </a>
        </div>
      </form>
    </div>

  <?php else: // ===== LIST + PAGINATION ===== ?>

    <?php
      // total item
      $total = 0;
      $countRes = $conn->query("SELECT COUNT(*) AS jml FROM produk");
      if ($countRes) { $rowC = $countRes->fetch_assoc(); $total = (int)$rowC['jml']; }

      // ambil data halaman ini
      $stmt = $conn->prepare("
        SELECT p.*, k.nama_kategori 
        FROM produk p 
        LEFT JOIN kategori k ON p.kategori_id = k.id 
        ORDER BY p.id DESC
        LIMIT ? OFFSET ?
      ");
      $stmt->bind_param("ii", $per_page, $offset);
      $stmt->execute();
      $res = $stmt->get_result();

      $total_pages = max(1, (int)ceil($total / $per_page));
      $window = 2; // current +/- 2
      $start  = max(1, $page - $window);
      $end    = min($total_pages, $page + $window);
    ?>

    <div class="box box-topbar p-3 p-md-4">
      <div class="d-flex justify-content-between align-items-center mb-3">
        <h2 class="h5 fw-bold m-0"><i class="fa-solid fa-boxes-stacked me-2"></i>Daftar Produk</h2>
        <a href="produk.php?action=add" class="btn btn-brand btn-sm px-3">
          <i class="fa-solid fa-plus me-1"></i> Tambah
        </a>
      </div>

      <div class="table-responsive">
        <table class="table table-hover table-striped table-bordered align-middle">
          <thead class="table-light">
            <tr>
              <th scope="col">Gambar</th>
              <th scope="col" style="min-width:260px">Nama Produk</th>
              <th scope="col">Kategori</th>
              <th scope="col">Harga</th>
              <th scope="col" class="text-center" style="width:160px">Aksi</th>
            </tr>
          </thead>
          <tbody>
            <?php if ($res && $res->num_rows > 0): ?>
              <?php while($row = $res->fetch_assoc()): ?>
                <tr>
                  <td><img src="../uploads/<?= e($row['gambar'] ?? 'default.png') ?>" class="thumb" alt="Produk"></td>
                  <td>
                    <div class="fw-bold"><?= e($row['nama_produk']) ?></div>
                    <?php if($row['deskripsi']): ?>
                      <small class="text-muted"><?= e(mb_strimwidth($row['deskripsi'], 0, 90, '…', 'UTF-8')) ?></small>
                    <?php endif; ?>
                  </td>
                  <td><span class="badge text-bg-warning badge-kat"><?= e($row['nama_kategori'] ?? 'Tanpa Kategori') ?></span></td>
                  <td class="price-cell">Rp <?= number_format((int)$row['harga'], 0, ',', '.') ?></td>
                  <td class="text-center">
                    <a class="btn btn-sm btn-primary me-1" href="produk.php?action=edit&id=<?= (int)$row['id'] ?>">
                      <i class="fa-solid fa-pen-to-square"></i>
                    </a>
                    <a class="btn btn-sm btn-danger"
                       href="produk.php?action=delete&id=<?= (int)$row['id'] ?>"
                       onclick="return confirm('⚠️ Yakin ingin menghapus produk \"<?= e($row['nama_produk']) ?>\"? Tindakan ini tidak dapat dibatalkan!')">
                      <i class="fa-solid fa-trash"></i>
                    </a>
                  </td>
                </tr>
              <?php endwhile; ?>
            <?php else: ?>
              <tr>
                <td colspan="5" class="text-center py-5 text-muted">
                  <div style="font-size:44px">📦</div>
                  <div class="fw-bold mt-2">Belum Ada Produk</div>
                  <small>Tambahkan produk pertama Anda untuk memulai penjualan</small>
                </td>
              </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>

      <!-- Pagination -->
      <?php if ($total_pages > 1): ?>
        <nav aria-label="Pagination produk" class="mt-3">
          <ul class="pagination justify-content-center flex-wrap gap-1">
            <!-- Prev -->
            <li class="page-item <?= $page <= 1 ? 'disabled' : '' ?>">
              <a class="page-link" href="<?= e($base_url) . ($page<=1 ? '' : (strpos($base_url,'?')!==false ? '&' : '?') . 'page=' . ($page-1)) ?>" tabindex="-1" aria-disabled="<?= $page<=1 ? 'true':'false' ?>">«</a>
            </li>

            <!-- First -->
            <?php if ($start > 1): ?>
              <li class="page-item"><a class="page-link" href="<?= e($base_url) . ((strpos($base_url,'?')!==false ? '&' : '?') . 'page=1') ?>">1</a></li>
              <?php if ($start > 2): ?><li class="page-item disabled"><span class="page-link">…</span></li><?php endif; ?>
            <?php endif; ?>

            <!-- Window -->
            <?php for($p=$start; $p<=$end; $p++): ?>
              <li class="page-item <?= $p===$page ? 'active' : '' ?>">
                <a class="page-link" href="<?= e($base_url) . ((strpos($base_url,'?')!==false ? '&' : '?') . 'page=' . $p) ?>"><?= $p ?></a>
              </li>
            <?php endfor; ?>

            <!-- Last -->
            <?php if ($end < $total_pages): ?>
              <?php if ($end < $total_pages-1): ?><li class="page-item disabled"><span class="page-link">…</span></li><?php endif; ?>
              <li class="page-item"><a class="page-link" href="<?= e($base_url) . ((strpos($base_url,'?')!==false ? '&' : '?') . 'page=' . $total_pages) ?>"><?= $total_pages ?></a></li>
            <?php endif; ?>

            <!-- Next -->
            <li class="page-item <?= $page >= $total_pages ? 'disabled' : '' ?>">
              <a class="page-link" href="<?= e($base_url) . ($page>=$total_pages ? '' : (strpos($base_url,'?')!==false ? '&' : '?') . 'page=' . ($page+1)) ?>">»</a>
            </li>
          </ul>
          <p class="text-center text-muted small mb-0">
            Menampilkan <?= min($per_page, max(0, $total - $offset)) ?> dari <?= $total ?> produk • Halaman <?= $page ?> / <?= $total_pages ?>
          </p>
        </nav>
      <?php endif; ?>
    </div>
  <?php endif; ?>
</div>

<script>
  // UX: format angka & validasi file
  document.addEventListener('DOMContentLoaded', () => {
    const harga = document.getElementById('harga');
    if (harga) harga.addEventListener('input', function(){ this.value = this.value.replace(/\D/g,''); });

    const fileInput = document.getElementById('gambar');
    if (fileInput) fileInput.addEventListener('change', function(){
      const f = this.files?.[0]; if(!f) return;
      if (f.size > 2 * 1024 * 1024) { alert('⚠️ Maksimal 2MB.'); this.value=''; }
    });

    // auto-hide alert
    document.querySelectorAll('.alert').forEach(a=>{
      setTimeout(()=>{ a.classList.add('fade'); a.style.opacity='0'; setTimeout(()=>a.remove(),250); }, 4500);
    });
  });
</script>

<?php require_once __DIR__ . '/../includes/footer_admin.php'; ?>
