<?php
// admin/kategori.php — CRUD Kategori + Warna
// ====== PROSES AKSI (WAJIB DI ATAS, sebelum output HTML) ======
if (session_status() === PHP_SESSION_NONE) session_start();
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/auth.php'; // pastikan path sesuai

// helper escape
if (!function_exists('e')) {
  function e($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
}
function hex_valid($h){
  return is_string($h) && preg_match('/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/', $h);
}
function sane_hex($h, $def){
  $h = strtoupper(trim((string)$h));
  return hex_valid($h) ? $h : $def;
}

// ===== Tambah / Update =====
if ($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['submit_kategori'])) {
  $id   = (int)($_POST['id'] ?? 0);
  $nama = trim($_POST['nama_kategori'] ?? '');

  $warna_awal  = sane_hex($_POST['warna_awal']  ?? '#FFD23F', '#FFD23F');
  $warna_akhir = sane_hex($_POST['warna_akhir'] ?? '#FF6B35', '#FF6B35');
  $warna_teks  = sane_hex($_POST['warna_teks']  ?? '#FFFFFF', '#FFFFFF');

  if ($nama === '') {
    $_SESSION['error'] = 'Nama kategori tidak boleh kosong.';
    header('Location: kategori.php'.($id?'?action=edit&id='.$id:'')); exit();
  }
  if (mb_strlen($nama) > 255) {
    $_SESSION['error'] = 'Nama kategori terlalu panjang (maks 255).';
    header('Location: kategori.php'.($id?'?action=edit&id='.$id:'')); exit();
  }

  // Cek duplikat nama (case-insensitive)
  if ($id === 0) {
    $cek = $conn->prepare("SELECT 1 FROM kategori WHERE LOWER(nama_kategori)=LOWER(?)");
    $cek->bind_param('s', $nama); $cek->execute();
    if ($cek->get_result()->num_rows > 0) {
      $_SESSION['error'] = 'Nama kategori sudah ada.';
      header('Location: kategori.php?action=add'); exit();
    }
    $stmt = $conn->prepare("INSERT INTO kategori (nama_kategori, warna_awal, warna_akhir, warna_teks) VALUES (?,?,?,?)");
    if (!$stmt) { $_SESSION['error'] = 'DB error: '.$conn->error; header('Location: kategori.php'); exit(); }
    $stmt->bind_param('ssss', $nama, $warna_awal, $warna_akhir, $warna_teks);
    $_SESSION['notice'] = $stmt->execute() ? 'Kategori berhasil ditambahkan.' : ('Gagal tambah kategori: '.$stmt->error);
  } else {
    $cek = $conn->prepare("SELECT 1 FROM kategori WHERE LOWER(nama_kategori)=LOWER(?) AND id<>?");
    $cek->bind_param('si', $nama, $id); $cek->execute();
    if ($cek->get_result()->num_rows > 0) {
      $_SESSION['error'] = 'Nama kategori sudah ada.';
      header('Location: kategori.php?action=edit&id='.$id); exit();
    }
    $stmt = $conn->prepare("UPDATE kategori SET nama_kategori=?, warna_awal=?, warna_akhir=?, warna_teks=? WHERE id=?");
    if (!$stmt) { $_SESSION['error'] = 'DB error: '.$conn->error; header('Location: kategori.php'); exit(); }
    $stmt->bind_param('ssssi', $nama, $warna_awal, $warna_akhir, $warna_teks, $id);
    $_SESSION['notice'] = $stmt->execute() ? 'Kategori berhasil diperbarui.' : ('Gagal update kategori: '.$stmt->error);
  }

  header('Location: kategori.php'); exit();
}

// ===== Hapus =====
if (isset($_GET['action'], $_GET['id']) && $_GET['action']==='delete') {
  $id = (int)$_GET['id'];

  // OPTIONAL: cegah hapus jika dipakai produk
  // $cek = $conn->prepare("SELECT 1 FROM produk WHERE kategori_id=? LIMIT 1");
  // $cek->bind_param('i', $id); $cek->execute();
  // if ($cek->get_result()->num_rows > 0) {
  //   $_SESSION['error'] = 'Kategori tidak bisa dihapus karena masih dipakai oleh produk.';
  //   header('Location: kategori.php'); exit();
  // }

  $del = $conn->prepare("DELETE FROM kategori WHERE id=?");
  if (!$del) { $_SESSION['error'] = 'DB error: '.$conn->error; header('Location: kategori.php'); exit(); }
  $del->bind_param('i', $id);
  $_SESSION['notice'] = $del->execute() ? 'Kategori berhasil dihapus.' : ('Gagal hapus kategori: '.$del->error);
  header('Location: kategori.php'); exit();
}

// ====== Setelah proses aksi, baru include header admin ======
$page_title = 'Kelola Kategori';
$breadcrumb = 'Admin / Kategori';
require_once __DIR__ . '/../includes/header_admin.php';

// ====== Variabel halaman & pagination ======
$action   = $_GET['action'] ?? 'list';
$per_page = 10;
$page     = isset($_GET['page']) ? max(1, (int)$_GET['page']) : 1;
$offset   = ($page - 1) * $per_page;

// helper: base url tanpa parameter page
function build_base_url_without($param='page'){
  $qs = $_GET; unset($qs[$param]);
  $base = basename($_SERVER['PHP_SELF']);
  return $base.(count($qs)?('?'.http_build_query($qs)):'');
}
$base_url = build_base_url_without('page');
?>

<style>
  .container, .container-sm, .container-md, .container-lg, .container-xl, .container-xxl,
  .content, .content-wrapper, .main-content, .page-content, .app-content, .app-main, .wrapper {
    max-width: 100% !important; width:100% !important;
  }
  .container-fluid { max-width: 100% !important; padding-left:24px !important; padding-right:24px !important; }
  .content, .content-wrapper, .main-content, .page-content, .app-content, .wrapper { margin-left:0 !important; margin-right:0 !important; }

  .box{
    background: rgba(255,255,255,.9); border:1px solid rgba(255,255,255,.6);
    border-radius:22px; box-shadow: 0 24px 60px rgba(21,23,42,.10);
  }
  .box-topbar{ position:relative; overflow:hidden }
  .box-topbar::before{
    content:""; position:absolute; left:14px; right:14px; top:0; height:6px; border-radius:0 0 8px 8px;
    background: linear-gradient(90deg, #ff7b54, #ff9068);
  }
  .btn-brand{
    color:#fff; border:0; border-radius:14px; font-weight:700;
    background: linear-gradient(135deg, #ff7b54, #ff9068);
    box-shadow: 0 12px 26px rgba(255,123,84,.35);
  }
  .btn-ghost{
    border:2px solid rgba(17,24,39,.08); border-radius:14px; font-weight:700;
    background:#fff; color:#111827;
  }
  .table-responsive{ overflow-x:auto }
  .badge-preview{
    display:inline-block; padding:6px 12px; border-radius:20px; font-weight:800;
    font-size:12px; box-shadow:0 2px 10px rgba(0,0,0,.07); border:1px solid rgba(255,255,255,.5);
  }
</style>

<div class="container-fluid py-3">
  <!-- Header -->
  <div class="box box-topbar p-4 mb-4">
    <div class="d-flex flex-column flex-md-row justify-content-between align-items-md-center gap-2">
      <div>
        <h1 class="h4 fw-bold m-0">🗂️ Kelola Kategori</h1>
        <div class="text-muted"><?= e($breadcrumb) ?></div>
      </div>
      <div>
        <?php if($action==='list'): ?>
          <a href="kategori.php?action=add" class="btn btn-brand px-3">
            <i class="fa-solid fa-plus me-2"></i>Tambah Kategori
          </a>
        <?php else: ?>
          <a href="kategori.php" class="btn btn-ghost px-3">
            <i class="fa-solid fa-arrow-left me-2"></i>Kembali
          </a>
        <?php endif; ?>
      </div>
    </div>
  </div>

  <!-- Flash -->
  <?php if(isset($_SESSION['notice'])){ ?>
    <div class="alert alert-success box fw-semibold"><?= '✅ '.e($_SESSION['notice']); ?></div>
  <?php unset($_SESSION['notice']); } ?>
  <?php if(isset($_SESSION['error'])){ ?>
    <div class="alert alert-danger box fw-semibold"><?= '❌ '.e($_SESSION['error']); ?></div>
  <?php unset($_SESSION['error']); } ?>

  <?php if ($action==='add' || ($action==='edit' && isset($_GET['id']))): ?>
    <?php
      $k = ['id'=>'','nama_kategori'=>'','warna_awal'=>'#FFD23F','warna_akhir'=>'#FF6B35','warna_teks'=>'#FFFFFF'];
      $title = 'Tambah Kategori'; $icon = 'fa-plus';
      if ($action==='edit'){
        $title = 'Edit Kategori'; $icon = 'fa-pen-to-square';
        $id = (int)$_GET['id'];
        $st = $conn->prepare("SELECT id, nama_kategori, warna_awal, warna_akhir, warna_teks FROM kategori WHERE id=?");
        $st->bind_param('i', $id); $st->execute();
        $r = $st->get_result();
        if ($r->num_rows>0) $k = $r->fetch_assoc();
      }
    ?>

    <div class="box box-topbar p-4 p-md-5 mb-4">
      <h2 class="h5 fw-bold mb-4"><i class="fa-solid <?= $icon ?> me-2"></i><?= e($title) ?></h2>

      <form action="kategori.php" method="POST" class="row g-3" id="form-kategori">
        <input type="hidden" name="id" value="<?= e($k['id']) ?>">

        <div class="col-12 col-md-6">
          <label class="form-label fw-bold text-uppercase small">Nama Kategori</label>
          <input name="nama_kategori" type="text" class="form-control" value="<?= e($k['nama_kategori']) ?>" required>
        </div>

        <div class="col-12">
          <label class="form-label fw-bold text-uppercase small d-block">Warna Badge (Gradient + Teks)</label>
          <div class="row g-2 align-items-center">
            <div class="col-12 col-md-3">
              <div class="small text-muted mb-1">Warna Awal</div>
              <input type="color" name="warna_awal" class="form-control form-control-color" value="<?= e($k['warna_awal'] ?? '#FFD23F') ?>">
            </div>
            <div class="col-12 col-md-3">
              <div class="small text-muted mb-1">Warna Akhir</div>
              <input type="color" name="warna_akhir" class="form-control form-control-color" value="<?= e($k['warna_akhir'] ?? '#FF6B35') ?>">
            </div>
            <div class="col-12 col-md-3">
              <div class="small text-muted mb-1">Warna Teks</div>
              <input type="color" name="warna_teks" class="form-control form-control-color" value="<?= e($k['warna_teks'] ?? '#FFFFFF') ?>">
            </div>
            <div class="col-12 col-md-3">
              <div class="small text-muted mb-1">Preview</div>
              <div id="badgePreview" class="badge-preview"
                   style="background: linear-gradient(135deg, <?= e($k['warna_awal'] ?? '#FFD23F') ?>, <?= e($k['warna_akhir'] ?? '#FF6B35') ?>); color: <?= e($k['warna_teks'] ?? '#FFFFFF') ?>;">
                <?= e($k['nama_kategori'] ?: 'Contoh') ?>
              </div>
            </div>
          </div>
        </div>

        <div class="col-12 d-flex gap-2">
          <button class="btn btn-brand px-3" type="submit" name="submit_kategori">
            <i class="fa-solid fa-floppy-disk me-2"></i> Simpan
          </button>
          <a class="btn btn-ghost px-3" href="kategori.php">
            <i class="fa-solid fa-arrow-left me-2"></i> Batal
          </a>
        </div>
      </form>
    </div>

    <script>
      // live preview badge warna + nama
      (function(){
        const f = document.getElementById('form-kategori');
        if(!f) return;
        const preview = document.getElementById('badgePreview');
        function upd(){
          const nama   = f.querySelector('input[name="nama_kategori"]').value || 'Contoh';
          const aw  = f.querySelector('input[name="warna_awal"]').value;
          const ak  = f.querySelector('input[name="warna_akhir"]').value;
          const tx  = f.querySelector('input[name="warna_teks"]').value;
          preview.style.background = `linear-gradient(135deg, ${aw}, ${ak})`;
          preview.style.color = tx;
          preview.textContent = nama;
        }
        f.addEventListener('input', upd);
      })();
    </script>

  <?php else: // LIST + PAGINATION ?>
    <?php
      // total
      $total = 0;
      $count = $conn->query("SELECT COUNT(*) AS jml FROM kategori");
      if ($count) { $rowC = $count->fetch_assoc(); $total = (int)$rowC['jml']; }

      // data halaman ini
      $stmt = $conn->prepare("SELECT id, nama_kategori, warna_awal, warna_akhir, warna_teks FROM kategori ORDER BY id DESC LIMIT ? OFFSET ?");
      $stmt->bind_param('ii', $per_page, $offset);
      $stmt->execute();
      $res = $stmt->get_result();

      $total_pages = max(1, (int)ceil($total / $per_page));
      $window = 2; $start = max(1, $page-$window); $end = min($total_pages, $page+$window);
    ?>

    <div class="box box-topbar p-3 p-md-4">
      <div class="d-flex justify-content-between align-items-center mb-3">
        <h2 class="h5 fw-bold m-0"><i class="fa-solid fa-folder-tree me-2"></i>Daftar Kategori</h2>
        <a href="kategori.php?action=add" class="btn btn-brand btn-sm px-3">
          <i class="fa-solid fa-plus me-1"></i> Tambah
        </a>
      </div>

      <div class="table-responsive">
        <table class="table table-hover table-striped table-bordered align-middle">
          <thead class="table-light">
            <tr>
              <th style="width:90px">ID</th>
              <th>Nama Kategori</th>
              <th style="width:260px">Warna</th>
              <th class="text-center" style="width:180px">Aksi</th>
            </tr>
          </thead>
          <tbody>
            <?php if ($res && $res->num_rows>0): ?>
              <?php while($row = $res->fetch_assoc()): ?>
                <tr>
                  <td><?= (int)$row['id'] ?></td>
                  <td class="fw-semibold"><?= e($row['nama_kategori']) ?></td>
                  <td>
                    <span class="badge-preview"
                          style="background:linear-gradient(135deg, <?= e($row['warna_awal']) ?>, <?= e($row['warna_akhir']) ?>); color: <?= e($row['warna_teks']) ?>;">
                      <?= e($row['nama_kategori']) ?>
                    </span>
                    <div class="small text-muted mt-1">
                      Awal: <?= e($row['warna_awal']) ?>,
                      Akhir: <?= e($row['warna_akhir']) ?>,
                      Teks: <?= e($row['warna_teks']) ?>
                    </div>
                  </td>
                  <td class="text-center">
                    <a class="btn btn-sm btn-primary me-1" href="kategori.php?action=edit&id=<?= (int)$row['id'] ?>">
                      <i class="fa-solid fa-pen-to-square"></i>
                    </a>
                    <a class="btn btn-sm btn-danger"
                       href="kategori.php?action=delete&id=<?= (int)$row['id'] ?>"
                       onclick="return confirm('Yakin ingin menghapus kategori \"<?= e($row['nama_kategori']) ?>\"?')">
                      <i class="fa-solid fa-trash"></i>
                    </a>
                  </td>
                </tr>
              <?php endwhile; ?>
            <?php else: ?>
              <tr>
                <td colspan="4" class="text-center py-5 text-muted">
                  <div style="font-size:44px">📁</div>
                  <div class="fw-bold mt-2">Belum Ada Kategori</div>
                  <small>Tambahkan kategori pertama Anda.</small>
                </td>
              </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>

      <!-- Pagination -->
      <?php if ($total_pages > 1): ?>
        <nav aria-label="Pagination kategori" class="mt-3">
          <ul class="pagination justify-content-center flex-wrap gap-1">
            <li class="page-item <?= $page<=1?'disabled':'' ?>">
              <a class="page-link" href="<?= e($base_url).($page<=1?'':(strpos($base_url,'?')!==false?'&':'?').'page='.($page-1)) ?>">«</a>
            </li>

            <?php if ($start > 1): ?>
              <li class="page-item"><a class="page-link" href="<?= e($base_url).((strpos($base_url,'?')!==false?'&':'?').'page=1') ?>">1</a></li>
              <?php if ($start > 2): ?><li class="page-item disabled"><span class="page-link">…</span></li><?php endif; ?>
            <?php endif; ?>

            <?php for($p=$start;$p<=$end;$p++): ?>
              <li class="page-item <?= $p===$page?'active':'' ?>">
                <a class="page-link" href="<?= e($base_url).((strpos($base_url,'?')!==false?'&':'?').'page='.$p) ?>"><?= $p ?></a>
              </li>
            <?php endfor; ?>

            <?php if ($end < $total_pages): ?>
              <?php if ($end < $total_pages-1): ?><li class="page-item disabled"><span class="page-link">…</span></li><?php endif; ?>
              <li class="page-item"><a class="page-link" href="<?= e($base_url).((strpos($base_url,'?')!==false?'&':'?').'page='.$total_pages) ?>"><?= $total_pages ?></a></li>
            <?php endif; ?>

            <li class="page-item <?= $page>=$total_pages?'disabled':'' ?>">
              <a class="page-link" href="<?= e($base_url).($page>=$total_pages?'':(strpos($base_url,'?')!==false?'&':'?').'page='.($page+1)) ?>">»</a>
            </li>
          </ul>
          <p class="text-center text-muted small mb-0">
            Menampilkan <?= min($per_page, max(0, $total - $offset)) ?> dari <?= $total ?> kategori • Halaman <?= $page ?> / <?= $total_pages ?>
          </p>
        </nav>
      <?php endif; ?>
    </div>
  <?php endif; ?>
</div>

<script>
  // auto-hide alert
  document.addEventListener('DOMContentLoaded', () => {
    document.querySelectorAll('.alert').forEach(a=>{
      setTimeout(()=>{ a.classList.add('fade'); a.style.opacity='0'; setTimeout(()=>a.remove(),250); }, 4500);
    });
  });
</script>

<?php require_once __DIR__ . '/../includes/footer_admin.php'; ?>
