<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
// Jika sudah login, redirect ke dashboard
if (isset($_SESSION['admin_id'])) {
    header("Location: dashboard.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Admin Login</title>
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">

  <style>
    /* =========================================
       Palet warna — samakan dengan halaman utama
       Jika di main CSS Anda sudah ada variabelnya,
       copas nilai-nilai ini agar benar-benar identik
       ========================================= */
    :root{
      /* Nuansa “aurora” lembut seperti di hero */
      --bg-base-0: #f7f8ff;   /* paling terang */
      --bg-base-1: #efeafd;   /* ungu pucat */
      --bg-base-2: #ffece3;   /* peach lembut */
      --bg-accent-1: #c7e7ff; /* biru muda */
      --bg-accent-2: #ffd6e5; /* pink lembut */
      --bg-accent-3: #dff7e4; /* hijau mint lembut */

      /* Aksen oranye selaras tombol “Pesan via WA / Lihat Menu” */
      --brand-1: #ff7b54;
      --brand-2: #ff9068;

      /* Warna komponen */
      --card-bg: rgba(255,255,255,0.87);
      --card-shadow: 0 24px 60px rgba(21, 23, 42, 0.10);
      --card-border: rgba(255,255,255,0.6);
      --text-strong: #2b2b36;
      --text-muted: #6b7280;
      --field-border: #e3e6ee;
      --field-bg: #fafbfe;
    }

    /* Reset ringkas */
    *{box-sizing:border-box;margin:0;padding:0}
    html,body{height:100%}
    body{
      font-family: ui-sans-serif, system-ui, -apple-system, "Segoe UI",
                   Roboto, "Helvetica Neue", Arial, "Noto Sans", "Apple Color Emoji",
                   "Segoe UI Emoji", "Segoe UI Symbol";
      color: var(--text-strong);
      /* ===== Latar belakang “aurora” berlapis (mirip halaman utama) ===== */
      background:
        radial-gradient(65rem 40rem at 10% -10%, var(--bg-accent-1) 0%, transparent 55%),
        radial-gradient(55rem 35rem at 90% 0%,  var(--bg-accent-2) 0%, transparent 52%),
        radial-gradient(70rem 45rem at 50% 110%, var(--bg-accent-3) 0%, transparent 50%),
        linear-gradient(180deg, var(--bg-base-0) 0%, var(--bg-base-1) 45%, var(--bg-base-2) 100%);
      min-height:100%;
      display:flex;
      align-items:center;
      justify-content:center;
      padding:32px;
      position:relative;
      overflow:hidden;
    }

    /* Noise halus + vignette supaya lembut seperti screenshot */
    body::before{
      content:"";
      position:fixed; inset:0;
      background:
        radial-gradient(120rem 60rem at 50% 0%, rgba(255,255,255,.55), transparent 60%),
        radial-gradient(120rem 60rem at 50% 100%, rgba(255,255,255,.35), transparent 60%);
      pointer-events:none;
      mix-blend-mode:soft-light;
    }
    body::after{
      content:"";
      position:fixed; inset:-20%;
      background:
        radial-gradient(100% 100% at 50% 50%, rgba(0,0,0,.06), transparent 65%);
      pointer-events:none;
    }

    /* Kontainer kartu login mengikuti gaya komponen di homepage */
    .login-container{
      width:100%;
      max-width: 440px;
      background: var(--card-bg);
      border: 1px solid var(--card-border);
      border-radius: 20px;
      box-shadow: var(--card-shadow);
      padding: 38px 34px;
      backdrop-filter: blur(10px);
      -webkit-backdrop-filter: blur(10px);
      animation: slideUp .7s ease-out;
      position:relative;
      overflow:hidden;
    }
    /* garis accent tipis di atas kartu (seperti border hijau di hero) */
    .login-container::before{
      content:"";
      position:absolute; left:14px; right:14px; top:0;
      height:6px; border-radius:0 0 8px 8px;
      background: linear-gradient(90deg, var(--brand-1), var(--brand-2));
      opacity:.9;
    }

    @keyframes slideUp{
      from{opacity:0; transform: translateY(22px) scale(.98)}
      to  {opacity:1; transform: translateY(0)   scale(1)}
    }

    .login-header{
      text-align:center; margin-bottom:28px;
    }
    .admin-icon{
      width:76px; height:76px; margin:0 auto 16px;
      border-radius:50%;
      display:flex; align-items:center; justify-content:center;
      color:#fff; font-size:30px;
      background: linear-gradient(135deg, var(--brand-1), var(--brand-2));
      box-shadow: 0 14px 28px rgba(255, 123, 84, .35);
    }
    h1{font-size:26px; font-weight:700; letter-spacing:.2px}
    .subtitle{color:var(--text-muted); font-size:14px; margin-top:6px}

    .error-msg{
      background: linear-gradient(135deg, #ff6b6b, #ee5a52);
      color:#fff; padding:12px 14px; border-radius:10px;
      text-align:center; font-size:14px; margin-bottom:18px;
      box-shadow: 0 10px 22px rgba(238, 90, 82, .25);
      animation: shake .45s ease-in-out;
    }
    @keyframes shake{
      0%,100%{transform:translateX(0)}
      25%{transform:translateX(-5px)}
      75%{transform:translateX( 5px)}
    }

    .form-group{margin-bottom:18px}
    label{display:block; font-size:14px; color:#4b5563; margin-bottom:8px; font-weight:600}

    .input-wrapper{position:relative}
    .input-icon{
      position:absolute; left:16px; top:50%; transform:translateY(-50%);
      color:#9aa3b2; font-size:18px; transition:color .25s ease;
    }
    input[type="text"], input[type="password"]{
      width:100%; padding:14px 16px 14px 46px; font-size:16px;
      border:2px solid var(--field-border); border-radius:12px;
      background: var(--field-bg); outline:none; transition: all .25s ease;
    }
    input[type="text"]:focus, input[type="password"]:focus{
      border-color: var(--brand-1);
      background:#fff;
      box-shadow: 0 0 0 4px rgba(255, 123, 84, .12);
      transform: translateY(-1px);
    }
    input:focus + .input-icon{ color: var(--brand-1); }

    .btn{
      width:100%; margin-top:8px;
      border:none; cursor:pointer; user-select:none;
      padding:14px 18px; border-radius:12px; font-size:15.5px; font-weight:700;
      color:#fff; letter-spacing:.4px; text-transform:uppercase;
      background: linear-gradient(135deg, var(--brand-1), var(--brand-2));
      transition: transform .12s ease, box-shadow .2s ease;
      position:relative; overflow:hidden;
      box-shadow: 0 12px 26px rgba(255, 123, 84, .35);
    }
    .btn::before{
      content:""; position:absolute; inset:0;
      background: linear-gradient(90deg, transparent, rgba(255,255,255,.35), transparent);
      transform: translateX(-100%); transition: transform .6s ease;
    }
    .btn:hover::before{ transform: translateX(100%) }
    .btn:hover{ transform: translateY(-1px) }
    .btn:active{ transform: translateY(0) }
    .btn.loading{ opacity:.8; pointer-events:none }
    .btn.loading::after{
      content:""; position:absolute; width:20px; height:20px; border-radius:50%;
      border:2px solid transparent; border-top-color:#fff;
      top:50%; left:50%; margin:-10px 0 0 -10px; animation:spin 1s linear infinite;
    }
    @keyframes spin{to{transform:rotate(360deg)}}

    .login-footer{
      text-align:center; margin-top:18px; color:var(--text-muted); font-size:12px;
    }

    /* Responsif */
    @media (max-width:480px){
      body{padding:20px}
      .login-container{padding:28px 22px}
      h1{font-size:22px}
      .admin-icon{width:64px;height:64px;font-size:24px}
    }
  </style>
</head>
<body>
  <div class="login-container">
    <div class="login-header">
      <div class="admin-icon"><i class="fas fa-user-shield"></i></div>
      <h1>Admin Login</h1>
      <p class="subtitle">Masuk ke panel administrasi</p>
    </div>

    <?php
      if (isset($_GET['error'])) {
          echo '<div class="error-msg"><i class="fas fa-exclamation-triangle"></i> ' . htmlspecialchars($_GET['error']) . '</div>';
      }
    ?>

    <form action="proses_login.php" method="POST" id="loginForm" autocomplete="off">
      <div class="form-group">
        <label for="username">Username</label>
        <div class="input-wrapper">
          <input type="text" id="username" name="username" required />
          <i class="fas fa-user input-icon"></i>
        </div>
      </div>

      <div class="form-group">
        <label for="password">Password</label>
        <div class="input-wrapper">
          <input type="password" id="password" name="password" required />
          <i class="fas fa-lock input-icon"></i>
        </div>
      </div>

      <button type="submit" class="btn" id="loginBtn">
        <i class="fas fa-sign-in-alt"></i> Login
      </button>
    </form>

    <div class="login-footer">
      <p>&copy; 2025 Admin Panel. All rights reserved.</p>
    </div>
  </div>

  <script>
    // State tombol saat submit
    document.getElementById('loginForm').addEventListener('submit', function(){
      const btn = document.getElementById('loginBtn');
      btn.classList.add('loading');
      btn.innerHTML = 'Memproses...';
    });

    // Warna ikon saat fokus
    document.querySelectorAll('input').forEach(inp=>{
      inp.addEventListener('focus', function(){
        const icon = this.parentNode.querySelector('.input-icon');
        if(icon) icon.style.color = getComputedStyle(document.documentElement)
                                   .getPropertyValue('--brand-1').trim();
      });
      inp.addEventListener('blur', function(){
        if(!this.value){
          const icon = this.parentNode.querySelector('.input-icon');
          if(icon) icon.style.color = '#9aa3b2';
        }
      });
    });

    // Enter dari username lompat ke password
    document.addEventListener('keydown', function(e){
      if(e.key === 'Enter'){
        const el = document.activeElement;
        if(el && el.id === 'username'){
          e.preventDefault();
          document.getElementById('password').focus();
        }
      }
    });
  </script>
</body>
</html>
