<?php
// admin/iklan.php — versi diperbaiki (tidak ada output sebelum header/redirect)

// ====== BOOTSTRAP & KEAMANAN DASAR ======
if (session_status() === PHP_SESSION_NONE) session_start();
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Ambil koneksi & auth SEBELUM ada output
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../admin/auth.php';

// Helper aman (jaga-jaga bila belum ada)
if (!function_exists('e')) {
  function e($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
}

// ====== FUNGSI UPLOAD GAMBAR ======
function upload_gambar_iklan($file){
  $dir = __DIR__ . '/../uploads/';
  if(!is_dir($dir)) @mkdir($dir,0775,true);

  $nama  = 'iklan_'.uniqid().'_'.preg_replace('/\s+/', '_', basename($file['name']));
  $target= $dir.$nama;
  $ext   = strtolower(pathinfo($target, PATHINFO_EXTENSION));
  if (!in_array($ext, ['jpg','jpeg','png','gif','webp'])) return false;

  $check = @getimagesize($file['tmp_name']);
  if ($check === false) return false;

  return move_uploaded_file($file['tmp_name'], $target) ? $nama : false;
}

// ====== PROSES POST/GET (HARUS DI ATAS, TANPA OUTPUT) ======
$action = $_GET['action'] ?? 'list';

// Tambah/Update
if ($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['submit_iklan'])) {
  $id    = (int)($_POST['id'] ?? 0);
  $judul = trim($_POST['judul'] ?? '');
  $desk  = trim($_POST['deskripsi'] ?? '');
  $aktif = isset($_POST['aktif']) ? 1 : 0;

  $lama  = $_POST['gambar_lama'] ?? '';
  $baru  = $lama;

  if (isset($_FILES['gambar']) && is_array($_FILES['gambar']) && ($_FILES['gambar']['error'] ?? 4) === 0) {
    $up = upload_gambar_iklan($_FILES['gambar']);
    if ($up) {
      $baru = $up;
      if ($lama && file_exists(__DIR__."/../uploads/".$lama)) {
        @unlink(__DIR__."/../uploads/".$lama);
      }
    } else {
      $_SESSION['error'] = 'Gagal mengupload gambar (pastikan JPG/PNG/GIF/WEBP).';
      header("Location: iklan.php".($id ? "?action=edit&id=$id" : ''));
      exit();
    }
  }

  if ($id === 0) {
    $st = $conn->prepare("INSERT INTO iklan (judul, deskripsi, gambar, aktif) VALUES (?,?,?,?)");
    if ($st) {
      $st->bind_param("sssi", $judul, $desk, $baru, $aktif);
      $_SESSION['notice'] = $st->execute() ? "Iklan berhasil ditambahkan." : "Gagal menambah iklan: ".$st->error;
      $st->close();
    } else {
      $_SESSION['error'] = "Query gagal disiapkan.";
    }
  } else {
    $st = $conn->prepare("UPDATE iklan SET judul=?, deskripsi=?, gambar=?, aktif=? WHERE id=?");
    if ($st) {
      $st->bind_param("sssii", $judul, $desk, $baru, $aktif, $id);
      $_SESSION['notice'] = $st->execute() ? "Iklan berhasil diperbarui." : "Gagal memperbarui iklan: ".$st->error;
      $st->close();
    } else {
      $_SESSION['error'] = "Query gagal disiapkan.";
    }
  }

  header("Location: iklan.php");
  exit();
}

// Hapus
if ($action === 'delete' && isset($_GET['id'])) {
  $id = (int)$_GET['id'];

  // Ambil gambar lama untuk dihapus
  $st = $conn->prepare("SELECT gambar FROM iklan WHERE id=?");
  if ($st) {
    $st->bind_param("i",$id);
    $st->execute();
    $r = $st->get_result()->fetch_assoc();
    $st->close();

    if ($r && !empty($r['gambar'])) {
      $file = __DIR__."/../uploads/".$r['gambar'];
      if (is_file($file)) @unlink($file);
    }
  }

  $d = $conn->prepare("DELETE FROM iklan WHERE id=?");
  if ($d) {
    $d->bind_param("i",$id);
    $_SESSION['notice'] = $d->execute() ? "Iklan berhasil dihapus." : "Gagal menghapus iklan: ".$d->error;
    $d->close();
  } else {
    $_SESSION['error'] = "Query hapus gagal disiapkan.";
  }

  header("Location: iklan.php");
  exit();
}

// ====== SET JUDUL & BREADCRUMB UNTUK HEADER ======
$page_title = 'Kelola Iklan';
$breadcrumb = 'Admin / Iklan';

// Setelah semua proses/redirect di atas, BARU tampilkan header (mulai output HTML)
require_once __DIR__ . '/../includes/header_admin.php';

// Dari sini aman untuk output HTML
?>

<style>
  :root{
    --brand-1:#ff7b54; --brand-2:#ff9068;
    --card-bg:rgba(255,255,255,.9); --card-border:rgba(255,255,255,.6);
  }
  .box{ background:var(--card-bg); border:1px solid var(--card-border); border-radius:22px; box-shadow:0 24px 60px rgba(21,23,42,.10); }
  .box-topbar{ position:relative; overflow:hidden }
  .box-topbar::before{ content:""; position:absolute; left:14px; right:14px; top:0; height:6px; border-radius:0 0 8px 8px; background:linear-gradient(90deg,var(--brand-1),var(--brand-2)); }
  .btn-brand{ color:#fff; border:0; border-radius:14px; font-weight:700; background:linear-gradient(135deg,var(--brand-1),var(--brand-2)); box-shadow:0 12px 26px rgba(255,123,84,.35); }
  .btn-ghost{ border:2px solid rgba(17,24,39,.08); border-radius:14px; font-weight:700; background:#fff; color:#111827; }
  .badge-active{ background:#dcfce7; color:#065f46; font-weight:800; }
  .badge-inactive{ background:#f3f4f6; color:#6b7280; font-weight:700; }
  .table img.thumb{ width:86px;height:56px;object-fit:cover;border-radius:10px;border:1px solid rgba(17,24,39,.1); }
</style>

<div class="container-fluid py-3">

  <!-- Header -->
  <div class="box box-topbar p-4 mb-4 d-flex justify-content-between align-items-center">
    <div>
      <h1 class="h4 fw-bold m-0">🎉 Kelola Iklan & Promosi</h1>
      <div class="text-muted"><?= e($breadcrumb) ?></div>
    </div>
    <?php if(($action ?? 'list')==='list'): ?>
      <a href="iklan.php?action=add" class="btn btn-brand px-3">
        <i class="fa-solid fa-plus me-2"></i>Tambah Iklan Baru
      </a>
    <?php endif; ?>
  </div>

  <!-- Notifikasi -->
  <?php if(isset($_SESSION['notice'])): ?>
    <div class="alert alert-success box fw-semibold"><?= e($_SESSION['notice']); unset($_SESSION['notice']); ?></div>
  <?php endif; ?>
  <?php if(isset($_SESSION['error'])): ?>
    <div class="alert alert-danger box fw-semibold"><?= e($_SESSION['error']); unset($_SESSION['error']); ?></div>
  <?php endif; ?>

  <?php
  // Siapkan data jika add/edit
  if (($action ?? 'list')==='add' || (($action ?? 'list')==='edit' && isset($_GET['id']))):
    $i = ['id'=>'','judul'=>'','deskripsi'=>'','gambar'=>'','aktif'=>0];
    $title = 'Tambah Iklan Baru';
    if (($action ?? 'list')==='edit') {
      $title='Edit Iklan';
      $id=(int)($_GET['id'] ?? 0);
      $st=$conn->prepare("SELECT * FROM iklan WHERE id=?");
      if ($st) {
        $st->bind_param("i",$id);
        $st->execute();
        $r=$st->get_result();
        if($r && $r->num_rows>0) $i=$r->fetch_assoc();
        $st->close();
      }
    }
  ?>

    <!-- Form -->
    <div class="box box-topbar p-4 p-md-5 mb-4">
      <h2 class="h5 fw-bold mb-3">
        <i class="fa-solid <?= (($action ?? 'add')==='add')?'fa-plus':'fa-pen-to-square' ?> me-2"></i><?= e($title) ?>
      </h2>
      <p class="text-muted mb-4">
        Kamu bisa mengaktifkan lebih dari satu iklan. Semua yang <strong>aktif</strong> akan tampil bergiliran di beranda (carousel).
      </p>

      <form action="iklan.php" method="POST" class="row g-3" enctype="multipart/form-data">
        <input type="hidden" name="id" value="<?= e($i['id']) ?>">
        <input type="hidden" name="gambar_lama" value="<?= e($i['gambar']) ?>">

        <div class="col-12">
          <label for="judul" class="form-label fw-bold text-uppercase small">Judul Iklan/Promosi</label>
          <input class="form-control" id="judul" name="judul" type="text" value="<?= e($i['judul']) ?>" required>
        </div>

        <div class="col-12">
          <label for="deskripsi" class="form-label fw-bold text-uppercase small">Deskripsi</label>
          <textarea class="form-control" id="deskripsi" name="deskripsi" rows="5" required><?= e($i['deskripsi']) ?></textarea>
        </div>

        <div class="col-md-7">
          <label for="gambar" class="form-label fw-bold text-uppercase small">Gambar Iklan</label>
          <input class="form-control" id="gambar" name="gambar" type="file" accept="image/*">
          <div class="form-text">Format: JPG/PNG/GIF/WEBP (maks ±2MB).</div>
        </div>

        <div class="col-md-5 d-flex align-items-end">
          <div class="form-check">
            <input class="form-check-input" type="checkbox" id="aktif" name="aktif" value="1" <?= ((int)$i['aktif']===1)?'checked':''; ?>>
            <label class="form-check-label" for="aktif"><strong>Aktifkan iklan ini</strong></label>
          </div>
        </div>

        <?php if(!empty($i['gambar'])): ?>
          <div class="col-12">
            <div class="p-3 border bg-white rounded-3 d-inline-flex align-items-center gap-3">
              <img src="../uploads/<?= e($i['gambar']) ?>" alt="Preview" class="thumb">
              <div class="small text-muted">Gambar saat ini</div>
            </div>
          </div>
        <?php endif; ?>

        <div class="col-12 d-flex gap-2">
          <button class="btn btn-brand px-3" type="submit" name="submit_iklan">
            <i class="fa-solid fa-floppy-disk me-2"></i> Simpan Iklan
          </button>
          <a class="btn btn-ghost px-3" href="iklan.php">
            <i class="fa-solid fa-arrow-left me-2"></i> Batal
          </a>
        </div>
      </form>
    </div>

  <?php else: ?>

    <!-- List -->
    <div class="box box-topbar p-3 p-md-4">
      <div class="d-flex justify-content-between align-items-center mb-3">
        <h2 class="h5 fw-bold m-0"><i class="fa-solid fa-bullhorn me-2"></i>Daftar Iklan</h2>
        <a href="iklan.php?action=add" class="btn btn-brand btn-sm px-3">
          <i class="fa-solid fa-plus me-1"></i> Tambah
        </a>
      </div>

      <div class="table-responsive">
        <table class="table table-hover table-striped table-bordered align-middle">
          <thead class="table-light">
            <tr>
              <th scope="col">Gambar</th>
              <th scope="col">Judul</th>
              <th scope="col">Status</th>
              <th scope="col" class="text-center" style="width:160px">Aksi</th>
            </tr>
          </thead>
          <tbody>
            <?php
            $res = $conn->query("SELECT * FROM iklan ORDER BY id DESC");
            if($res && $res->num_rows>0):
              while($row=$res->fetch_assoc()):
                $aktif = (int)$row['aktif']===1;
            ?>
            <tr>
              <td><img src="../uploads/<?= e($row['gambar'] ?? 'default.png') ?>" class="thumb" alt=""></td>
              <td class="fw-semibold"><?= e($row['judul']) ?></td>
              <td>
                <?php if($aktif): ?>
                  <span class="badge rounded-pill badge-active px-3 py-2">Aktif</span>
                <?php else: ?>
                  <span class="badge rounded-pill badge-inactive px-3 py-2">Tidak Aktif</span>
                <?php endif; ?>
              </td>
              <td class="text-center">
                <a class="btn btn-sm btn-primary me-1" href="iklan.php?action=edit&id=<?= (int)$row['id'] ?>">
                  <i class="fa-solid fa-pen-to-square"></i>
                </a>
                <a class="btn btn-sm btn-danger"
                   href="iklan.php?action=delete&id=<?= (int)$row['id'] ?>"
                   onclick="return confirm('Yakin ingin menghapus iklan ini?')">
                  <i class="fa-solid fa-trash"></i>
                </a>
              </td>
            </tr>
            <?php endwhile; else: ?>
            <tr>
              <td colspan="4" class="text-center py-5 text-muted">
                <div style="font-size:44px">📰</div>
                <div class="fw-bold mt-2">Belum ada iklan.</div>
                <small>Tambahkan iklan untuk ditampilkan di beranda</small>
              </td>
            </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>

  <?php endif; ?>
</div>

<script>
  // Validasi ukuran file & auto-hide alert
  document.addEventListener('DOMContentLoaded', () => {
    const file = document.getElementById('gambar');
    if (file) {
      file.addEventListener('change', function(){
        const f = this.files?.[0]; if(!f) return;
        if (f.size > 2 * 1024 * 1024) { // 2MB
          alert('⚠️ Ukuran file terlalu besar! Maksimal 2MB.');
          this.value = '';
        }
      });
    }
    document.querySelectorAll('.alert').forEach(a=>{
      setTimeout(()=>{ a.classList.add('fade'); a.style.opacity='0'; setTimeout(()=>a.remove(),250); }, 4500);
    });
  });
</script>

<?php require_once __DIR__ . '/../includes/footer_admin.php'; ?>
