<?php
// admin/get_produk.php — menghasilkan HTML grid produk (AJAX) + PAGINATION
require_once __DIR__ . '/../includes/db.php';

/* ---------- Helpers ---------- */
function e($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
function rupiah($n){ return 'Rp ' . number_format((float)$n, 0, ',', '.'); }
function adjustBrightness($hex, $steps = 20){
  $hex = str_replace('#','',$hex);
  if (strlen($hex) === 3){ $hex = $hex[0].$hex[0].$hex[1].$hex[1].$hex[2].$hex[2]; }
  $r = max(0, min(255, hexdec(substr($hex,0,2)) + $steps));
  $g = max(0, min(255, hexdec(substr($hex,2,2)) + $steps));
  $b = max(0, min(255, hexdec(substr($hex,4,2)) + $steps));
  return sprintf("#%02x%02x%02x",$r,$g,$b);
}
function valid_hex($h){
  return is_string($h) && preg_match('/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/', $h);
}

/* ---------- Input ---------- */
$selected_kategori_id = null;
if (isset($_GET['kategori_id']) && $_GET['kategori_id'] !== '' && $_GET['kategori_id'] !== 'all') {
  if (ctype_digit((string)$_GET['kategori_id'])) {
    $selected_kategori_id = (int)$_GET['kategori_id'];
  }
}
$PER_PAGE = isset($_GET['per_page']) && ctype_digit((string)$_GET['per_page']) ? max(1, (int)$_GET['per_page']) : 12;
$page     = isset($_GET['page']) && ctype_digit((string)$_GET['page']) ? max(1, (int)$_GET['page']) : 1;
$offset   = ($page - 1) * $PER_PAGE;

/* ---------- Total rows ---------- */
if ($selected_kategori_id !== null) {
  $stCount = $conn->prepare("SELECT COUNT(*) AS jml FROM produk WHERE kategori_id = ?");
  $stCount->bind_param('i', $selected_kategori_id);
} else {
  $stCount = $conn->prepare("SELECT COUNT(*) AS jml FROM produk");
}
$stCount->execute();
$total = (int)$stCount->get_result()->fetch_assoc()['jml'];
$stCount->close();

$total_pages = max(1, (int)ceil($total / $PER_PAGE));

/* ---------- Data page (PAKAI WARNA KATEGORI) ---------- */
if ($selected_kategori_id !== null) {
  $stmt = $conn->prepare("
    SELECT p.id, p.nama_produk, p.deskripsi, p.harga, p.gambar,
           k.nama_kategori, k.warna_awal, k.warna_akhir, k.warna_teks
    FROM produk p
    LEFT JOIN kategori k ON p.kategori_id = k.id
    WHERE p.kategori_id = ?
    ORDER BY p.id DESC
    LIMIT ? OFFSET ?
  ");
  $stmt->bind_param('iii', $selected_kategori_id, $PER_PAGE, $offset);
} else {
  $stmt = $conn->prepare("
    SELECT p.id, p.nama_produk, p.deskripsi, p.harga, p.gambar,
           k.nama_kategori, k.warna_awal, k.warna_akhir, k.warna_teks
    FROM produk p
    LEFT JOIN kategori k ON p.kategori_id = k.id
    ORDER BY p.id DESC
    LIMIT ? OFFSET ?
  ");
  $stmt->bind_param('ii', $PER_PAGE, $offset);
}
$stmt->execute();
$res = $stmt->get_result();

/* ---------- Output ---------- */
header('Content-Type: text/html; charset=UTF-8');

if ($res && $res->num_rows > 0):
  echo '<div class="product-grid">';

  // fallback palet jika kategori belum punya warna
  $fallbackPalette = [
    '#ff6b35','#06d6a0','#ffd23f','#8b5cf6','#ef4444',
    '#3b82f6','#10b981','#f59e0b','#ec4899','#14b8a6',
    '#f97316','#84cc16','#6366f1','#d946ef','#06b6d4'
  ];
  $delay = 0;

  while ($row = $res->fetch_assoc()):
    $id    = (int)$row['id'];
    $nama  = e($row['nama_produk'] ?? '');
    $descO = (string)($row['deskripsi'] ?? '');
    if (function_exists('mb_strlen') && function_exists('mb_substr')) {
      $desc = mb_strlen($descO) > 90 ? mb_substr($descO, 0, 90).'…' : $descO;
    } else {
      $desc = strlen($descO) > 90 ? substr($descO, 0, 90).'…' : $descO;
    }
    $desc  = e($desc);
    $harga = (float)($row['harga'] ?? 0);

    $kat   = e($row['nama_kategori'] ?? 'Kategori');

    // ---- Warna kategori dari DB (punya 3 kolom). Kalau kosong/invalid -> fallback hash warna.
    $w1 = $row['warna_awal']  ?? '';
    $w2 = $row['warna_akhir'] ?? '';
    $wt = $row['warna_teks']  ?? '';

    if (!valid_hex($w1) || !valid_hex($w2)) {
      // fallback pakai hash nama kategori
      $base = $fallbackPalette[abs(crc32($kat)) % count($fallbackPalette)];
      $w1   = $base;
      $w2   = adjustBrightness($base, 30);
    }
    if (!valid_hex($wt)) $wt = '#FFFFFF';

    // ---- Icon kategori (opsional)
    $katIcon = '🍽️';
    $kl = strtolower($row['nama_kategori'] ?? '');
    if (str_contains($kl,'minum') || str_contains($kl,'drink')) $katIcon = '🥤';
    elseif (str_contains($kl,'snack') || str_contains($kl,'cemil')) $katIcon = '🍿';
    elseif (str_contains($kl,'dessert') || str_contains($kl,'manis')) $katIcon = '🍰';
    elseif (str_contains($kl,'sop') || str_contains($kl,'soup')) $katIcon = '🍲';
    elseif (str_contains($kl,'ayam') || str_contains($kl,'chicken')) $katIcon = '🍗';
    elseif (str_contains($kl,'ikan') || str_contains($kl,'seafood')) $katIcon = '🐟';

    // ---- Gambar
    $img = !empty($row['gambar'])
      ? 'uploads/'.e($row['gambar'])
      : 'data:image/svg+xml,'.urlencode(
        '<svg xmlns="http://www.w3.org/2000/svg" width="600" height="400">
           <defs><linearGradient id="g" x1="0" y1="0" x2="1" y2="1">
             <stop offset="0%" stop-color="#f1f5f9"/><stop offset="100%" stop-color="#e2e8f0"/></linearGradient></defs>
           <rect width="100%" height="100%" fill="url(#g)"/>
           <text x="50%" y="45%" dominant-baseline="middle" text-anchor="middle"
                 fill="#64748b" font-size="42" font-family="Arial">🍽️</text>
           <text x="50%" y="62%" dominant-baseline="middle" text-anchor="middle"
                 fill="#94a3b8" font-size="14" font-family="Arial">Gambar tidak tersedia</text>
         </svg>'
      );

    echo '<a class="product-card-link" href="detail.php?id='.$id.'" style="animation-delay:'.($delay*0.08).'s">';
    echo '  <article class="card" itemscope itemtype="https://schema.org/Product">';
    echo '    <div class="media">';
    echo '      <img src="'.$img.'" alt="'.$nama.'" loading="lazy"
                     onerror="this.src=\'data:image/svg+xml,&lt;svg xmlns=&quot;http://www.w3.org/2000/svg&quot; width=&quot;600&quot; height=&quot;400&quot;&gt;&lt;rect width=&quot;100%&quot; height=&quot;100%&quot; fill=&quot;#f1f5f9&quot;/&gt;&lt;text x=&quot;50%&quot; y=&quot;50%&quot; dominant-baseline=&quot;middle&quot; text-anchor=&quot;middle&quot; fill=&quot;#64748b&quot; font-size=&quot;16&quot; font-family=&quot;Arial&quot;&gt;Gambar tidak tersedia&lt;/text&gt;&lt;/svg&gt;\'">';
    echo '      <div class="category-badge" style="background:linear-gradient(135deg,'.$w1.','.$w2.');color:'.$wt.';">'.$katIcon.' '.$kat.'</div>';
    echo '      <div class="rating-overlay"><div class="stars">
                  <span class="star filled">★</span>
                  <span class="star filled">★</span>
                  <span class="star filled">★</span>
                  <span class="star filled">★</span>
                  <span class="star '.(($delay%3)===0?'filled':'empty').'">★</span>
                </div></div>';
    echo '    </div>';
    echo '    <div class="body">';
    echo '      <h4 itemprop="name">'.$nama.'</h4>';
    echo '      <div class="desc" itemprop="description">'.$desc.'</div>';
    echo '      <div class="price-section">';
    echo '        <div class="price" itemprop="offers" itemscope itemtype="https://schema.org/Offer">
                    <span class="price-text" itemprop="price" content="'.$harga.'">'.rupiah($harga).'</span>
                    <meta itemprop="priceCurrency" content="IDR">
                  </div>';
    echo '        <div class="quick-actions">';
    echo '          <button class="quick-btn cart-btn" type="button" data-id="'.$id.'" data-name="'.$nama.'" title="Tambah ke keranjang" aria-label="Tambah ke keranjang">
                      <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M9 22a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z"/><path d="M20 22a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z"/>
                        <path d="M1 1h4l2.68 13.39a2 2 0 0 0 2 1.61h9.72a2 2 0 0 0 2-1.61L23 6H6"/>
                      </svg>
                    </button>';
    echo '          <button class="quick-btn whatsapp-btn" type="button" data-name="'.$nama.'" title="Pesan via WhatsApp" aria-label="Pesan via WhatsApp">
                      <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347"/>
                        <path d="M12.051 21.785a9.87 9.87 0 0 1-5.392-1.484l-3.7.973.99-3.617A9.864 9.864 0 1 1 12.05 21.785z"/>
                      </svg>
                    </button>';
    echo '        </div>';
    echo '      </div>';
    echo '    </div>';
    echo '  </article>';
    echo '</a>';

    $delay++;
  endwhile;

  echo '</div>'; // .product-grid

  /* ---------- Pagination ---------- */
  if ($total_pages > 1):
    $win = 2; $start = max(1, $page - $win); $end = min($total_pages, $page + $win);
    ?>
    <nav class="product-pagination" aria-label="Halaman produk" style="margin-top:18px;display:flex;justify-content:center">
      <ul class="pagination" style="display:flex;gap:8px;list-style:none;padding:0;margin:0">
        <li>
          <a href="#" class="page-link" data-page="<?= max(1, $page-1) ?>"
             aria-disabled="<?= $page<=1?'true':'false' ?>"
             style="text-decoration:none;padding:10px 14px;border:2px solid #e2e8f0;border-radius:12px;background:#fff;color:#0a0e27;<?= $page<=1?'opacity:.5;pointer-events:none;':'' ?>">«</a>
        </li>

        <?php if ($start > 1): ?>
          <li><a href="#" class="page-link" data-page="1" style="text-decoration:none;padding:10px 14px;border:2px solid #e2e8f0;border-radius:12px;background:#fff;color:#0a0e27">1</a></li>
          <?php if ($start > 2): ?><li><span class="page-ellipsis" style="padding:10px 6px;color:#94a3b8">…</span></li><?php endif; ?>
        <?php endif; ?>

        <?php for ($p=$start; $p<=$end; $p++):
          $active = $p===$page ? 'background:linear-gradient(135deg,#ff6b35,#ff8960);color:#fff;border-color:transparent;' : '';
        ?>
          <li><a href="#" class="page-link" data-page="<?= $p ?>" style="text-decoration:none;padding:10px 14px;border:2px solid #e2e8f0;border-radius:12px;background:#fff;color:#0a0e27;<?= $active ?>"><?= $p ?></a></li>
        <?php endfor; ?>

        <?php if ($end < $total_pages): ?>
          <?php if ($end < $total_pages-1): ?><li><span class="page-ellipsis" style="padding:10px 6px;color:#94a3b8">…</span></li><?php endif; ?>
          <li><a href="#" class="page-link" data-page="<?= $total_pages ?>" style="text-decoration:none;padding:10px 14px;border:2px solid #e2e8f0;border-radius:12px;background:#fff;color:#0a0e27"><?= $total_pages ?></a></li>
        <?php endif; ?>

        <li>
          <a href="#" class="page-link" data-page="<?= min($total_pages, $page+1) ?>"
             aria-disabled="<?= $page>=$total_pages?'true':'false' ?>"
             style="text-decoration:none;padding:10px 14px;border:2px solid #e2e8f0;border-radius:12px;background:#fff;color:#0a0e27;<?= $page>=$total_pages?'opacity:.5;pointer-events:none;':'' ?>">»</a>
        </li>
      </ul>
    </nav>
    <p class="pagination-meta" style="text-align:center;color:#64748b;margin-top:10px">
      Menampilkan <strong><?= min($PER_PAGE, max(0, $total - $offset)) ?></strong> dari <strong><?= $total ?></strong> produk • Halaman <strong><?= $page ?></strong> / <strong><?= $total_pages ?></strong>
    </p>
    <?php
  endif;

  /* ---------- CSS kecil & interaksi ---------- */
  ?>
  <style>
    .product-grid .product-card-link, .product-grid .product-card-link * { text-decoration: none !important; }
    .product-grid .product-card-link { color: inherit; display:block; }
    .product-grid{display:grid;gap:24px;grid-template-columns:repeat(auto-fill,minmax(280px,1fr))}
    .product-grid .product-card-link{opacity:0;transform:translateY(26px);animation:pgIn .6s ease-out forwards}
    @keyframes pgIn{to{opacity:1;transform:translateY(0)}}
    .card{background:linear-gradient(145deg,#fff 0%,#f8fafc 100%);border:2px solid #f1f5f9;border-radius:20px;box-shadow:0 4px 20px rgba(0,0,0,.08);overflow:hidden;display:flex;flex-direction:column;transition:.28s ease}
    .card:hover{transform:translateY(-6px);box-shadow:0 24px 60px rgba(0,0,0,.12);border-color:#ff6b35}
    .media{aspect-ratio:4/3;background:#fff;position:relative;overflow:hidden}
    .media img{width:100%;height:100%;object-fit:contain;padding:12px;transition:transform .3s}
    .card:hover .media img{transform:scale(1.05)}
    .category-badge{position:absolute;top:14px;left:14px;color:#fff;font-size:12px;font-weight:800;padding:6px 12px;border-radius:999px;letter-spacing:.5px;box-shadow:0 6px 18px rgba(0,0,0,.12)}
    .rating-overlay{position:absolute;top:14px;right:14px;background:rgba(255,255,255,.95);backdrop-filter:blur(8px);padding:6px 10px;border-radius:12px;box-shadow:0 2px 8px rgba(0,0,0,.08)}
    .stars{display:flex;gap:2px;font-size:13px}.star.filled{color:#fbbf24}.star.empty{color:#d1d5db}
    .body{padding:18px;display:flex;flex-direction:column;gap:8px}
    .body h4{margin:0;font-size:18px;font-weight:900;color:#0f172a;display:-webkit-box;-webkit-line-clamp:1;-webkit-box-orient:vertical;overflow:hidden}
    .desc{font-size:14px;color:#64748b;min-height:48px;display:-webkit-box;-webkit-line-clamp:2;-webkit-box-orient:vertical;overflow:hidden;line-height:1.5}
    .price-section{display:flex;align-items:center;justify-content:space-between;margin-top:auto;gap:12px}
    .price .price-text{font-weight:900;color:#ff6b35;font-size:20px;letter-spacing:-.02em}
    .quick-actions{display:flex;gap:10px;opacity:0;transform:translateY(6px);transition:all .25s}
    .card:hover .quick-actions{opacity:1;transform:translateY(0)}
    .quick-btn{width:40px;height:40px;border:none;border-radius:12px;background:#f1f5f9;color:#64748b;display:flex;align-items:center;justify-content:center;cursor:pointer;transition:.2s}
    .quick-btn:hover{transform:scale(1.08)}
    .cart-btn:hover{background:linear-gradient(135deg,#ff6b35,#ff8960);color:#fff}
    .whatsapp-btn:hover{background:linear-gradient(135deg,#10b981,#34d399);color:#fff}
    @media (max-width:768px){ .product-grid{grid-template-columns:repeat(auto-fill,minmax(240px,1fr));gap:16px} .quick-actions{opacity:1;transform:none} }
  </style>
  <script>
    // Mini interaksi tombol cepat
    document.querySelectorAll('.cart-btn').forEach(btn=>{
      btn.addEventListener('click', e=>{
        e.preventDefault(); e.stopPropagation();
        btn.style.background = 'linear-gradient(135deg,#10b981,#34d399)';
        btn.style.color = '#fff';
        btn.innerHTML = '✓';
        setTimeout(()=>{ btn.style.background=''; btn.style.color='';
          btn.innerHTML = '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M9 22a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z"/><path d="M20 22a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z"/><path d="M1 1h4l2.68 13.39a2 2 0 0 0 2 1.61h9.72a2 2 0 0 0 2-1.61L23 6H6"/></svg>';
        }, 1100);
      });
    });
    document.querySelectorAll('.whatsapp-btn').forEach(btn=>{
      btn.addEventListener('click', e=>{
        e.preventDefault(); e.stopPropagation();
        const name = btn.dataset.name || '';
        const msg = encodeURIComponent('Halo, saya tertarik dengan ' + name + ' dari Kedai Salsabilla');
        window.open('https://wa.me/6283821470781?text=' + msg, '_blank', 'noopener');
      });
    });
  </script>
  <?php

else:
  echo '<div class="empty-state">
          <div class="empty-icon">
            <svg width="64" height="64" viewBox="0 0 24 24" fill="none" stroke="#cbd5e1" stroke-width="1">
              <circle cx="12" cy="12" r="10"/><path d="M16 16s-1.5-2-4-2-4 2-4 2"/><line x1="9" y1="9" x2="9.01" y2="9"/><line x1="15" y1="9" x2="15.01" y2="9"/>
            </svg>
          </div>
          <h3>Belum ada produk</h3>
          <p>Produk untuk kategori ini belum tersedia.</p>
        </div>
        <style>
          .empty-state{text-align:center;padding:60px 20px;background:#fff;border:2px solid #f1f5f9;border-radius:20px;box-shadow:0 4px 20px rgba(0,0,0,.08)}
          .empty-state h3{margin:10px 0 8px;font-size:20px;color:#334155}
          .empty-state p{margin:0;color:#64748b}
          .empty-icon{opacity:.8}
        </style>';
endif;

/* ---------- Cleanup ---------- */
$stmt?->close();
$conn?->close();
